PLUGINS.Devices.push({
    "name": "Mikrotik info",
    "isApplicable": function (sysDescr) {
        return sysDescr.indexOf("RouterOS") !== -1;
    },
    "loadInfo": async function (device) {
        let info = [];
        //заголовок
        info.push({
            "type": "header",
            "caption": "System resources"
        });

        const walk = await SNMP.walk(device, "1.3.6.1.2.1.25.3.3.1.2");
        for (const oid in walk) {
            const value = walk[oid];
            const index = oid.substring(oid.lastIndexOf('.') + 1);

            info.push({
                "type": "row",
                "caption": "CPU Core " + index + " usage",
                "value": value,
                "units": "%"
            });
        }

        let hddSize = parseInt(await SNMP.get(device, "1.3.6.1.2.1.25.2.3.1.5.65536"));
        let used = parseInt(await SNMP.get(device, "1.3.6.1.2.1.25.2.3.1.6.65536"));

        info.push({
            "type": "row",
            "caption": "HDD Usage",
            "value": (used / hddSize * 100).toFixed(0),
            "units": "%"
        });


        info.push({
            "type": "row",
            "caption": "Firmware version",
            "value": await SNMP.get(device, "1.3.6.1.4.1.14988.1.1.7.4.0"),
            "units": ""
        });

        info.push({
            "type": "row",
            "caption": "Software version",
            "value": await SNMP.get(device, "1.3.6.1.4.1.14988.1.1.4.4.0"),
            "units": ""
        });

        const connectedIfaces = [];
        for (const iface of device.interfaces) {
            if (iface.connections.length > 0) {
                connectedIfaces.push(iface);
            }
        }


        info.push({
            "type": "header",
            "caption": "Connected interfaces speed"
        });


        for (const iface of connectedIfaces) {
            info.push({
                "type": "row",
                "caption": "Interface " + iface.name,
                "value": await SNMP.get(device, "1.3.6.1.2.1.2.2.1.5." + iface.index) / 1000000,
                "units": "Mbit/s"
            });
        }


        return info;
    }
});