PLUGINS.Devices.push({
    "name": "H3C info",
    "isApplicable": function (sysDescr) {
        return sysDescr.indexOf("H3C Comware Platform Software") !== -1;
    },
    "loadInfo": async function (device) {
        let info = [];
        info.push({
            "type": "header",
            "caption": "SFP Info"
        });

        const convertLevel = function (value) {
            return (10 * Math.log10(value * 0.0001)).toFixed(2);
        };


        for (const iface of device.interfaces) {
            if (iface.connections.length > 0) {

                info.push({
                    "type": "row",
                    "caption": iface.name + " RX Power Level",
                    "value": convertLevel(parseInt(await SNMP.get(device, "1.3.6.1.4.1.9636.1.18.2.2.1.1.2." + iface.index + ".4"))),
                    "units": "dBm"
                });
                info.push({
                    "type": "row",
                    "caption": iface.name + " TX Power Level",
                    "value": convertLevel(parseInt(await SNMP.get(device, "1.3.6.1.4.1.9636.1.18.2.2.1.1.2." + iface.index + ".3"))),
                    "units": "dBm"
                });

                info.push({
                    "type": "row",
                    "caption": iface.name + " wavelength",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.9636.1.18.2.1.1.1.16." + iface.index)),
                    "units": "nm"
                });
            }
        }


        return info;
    }
});