PLUGINS.Devices.push({
    "name": "FiberHome info",
    "isApplicable": function (sysDescr) {
        return sysDescr.indexOf("Fengine Sw Ver USP") !== -1;
    },
    "loadInfo": async function (device) {
        let info = [];
        info.push({
            "type": "header",
            "caption": "SFP Info"
        });


        for (const iface of device.interfaces) {
            if (iface.connections.length > 0) {

                info.push({
                    "type": "row",
                    "caption": iface.name + " RX Power Level",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.3807.3.305.2.1.11." + iface.index)) / 100,
                    "units": "dBm"
                });
                info.push({
                    "type": "row",
                    "caption": iface.name + " TX Power Level",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.3807.3.305.2.1.14." + iface.index)) / 100,
                    "units": "dBm"
                });

                info.push({
                    "type": "row",
                    "caption": iface.name + " wavelength",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.3807.3.305.2.1.20." + iface.index)),
                    "units": "nm"
                });
            }
        }


        return info;
    }
});