/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.utils.logging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import ru.kirillius.utils.logging.LogHandler;

public final class SystemLogger
extends Logger {
    private static SystemLogger instance = null;
    public static final String LOGGER_NAME = "SystemLogger";
    private boolean debugPrint;

    private static synchronized SystemLogger getInstance() {
        return instance;
    }

    private static InputStream getConfigAsStream(boolean debug) {
        return new ByteArrayInputStream(("handlers=" + LogHandler.class.getName() + (debug ? "\r\n.level=ALL" : "")).getBytes());
    }

    public static void initializeLogging(boolean debugPrint) {
        if (instance != null) {
            throw new IllegalStateException("Initialized already");
        }
        try (InputStream stream = SystemLogger.getConfigAsStream(debugPrint);){
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize logging");
        }
        instance = new SystemLogger(debugPrint);
    }

    private SystemLogger(boolean debug) {
        super(LOGGER_NAME, null);
        LogManager.getLogManager().addLogger(this);
        this.debugPrint = debug;
    }

    public static void debug(String message, String context) {
        SystemLogger.getInstance().fine(SystemLogger.formatContext(context, message));
    }

    public static void message(String message, String context) {
        SystemLogger.getInstance().info(SystemLogger.formatContext(context, message));
    }

    public static void error(String message, String context) {
        SystemLogger.getInstance().severe(SystemLogger.formatContext(context, message));
    }

    public static void error(String message, String context, Throwable throwable) {
        StringBuffer buffer = new StringBuffer();
        SystemLogger.recursiveDumpException(throwable, buffer);
        SystemLogger.getInstance().severe(SystemLogger.formatContext(context, message + "\r\n" + buffer));
    }

    private static String formatContext(String context, String message) {
        if (context != null) {
            return context + "> " + message;
        }
        return message;
    }

    private static void recursiveDumpException(Throwable throwable, StringBuffer buffer) {
        String name = throwable.getClass().getSimpleName();
        String message = throwable.getMessage();
        Throwable cause = throwable.getCause();
        buffer.append(name).append(":").append(message);
        if (!SystemLogger.instance.debugPrint) {
            return;
        }
        buffer.append("\nStack trace:\n");
        for (StackTraceElement element : throwable.getStackTrace()) {
            buffer.append(element.toString()).append("\n");
        }
        if (cause != null) {
            buffer.append("caused by ");
            SystemLogger.recursiveDumpException(cause, buffer);
        }
    }
}

