/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.utils.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogHandler
extends Handler {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.US);
    private static volatile PrintWriter outputFile = null;

    private String format(LogRecord logRecord) {
        Date date = new Date(logRecord.getMillis());
        return "[" + dateFormat.format(date) + "][" + logRecord.getLevel().getName() + "] " + logRecord.getMessage().trim();
    }

    public static void setOutputFile(File f) {
        try {
            outputFile = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        System.out.println(this.format(logRecord));
        if (outputFile != null) {
            outputFile.println(this.format(logRecord));
            outputFile.flush();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

