/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;
import ru.kirillius.snmp.tools.SNMPService;

public class SNMPTableReader {
    protected final SNMPConnectionSettings connectionSettings;
    protected final Map<OID, Variable> table = new HashMap<OID, Variable>();

    public SNMPTableReader(SNMPConnectionSettings connectionSettings) {
        this.connectionSettings = connectionSettings;
    }

    protected void readTable(String oid) {
        this.table.putAll(SNMPService.getInstance().walk(oid, this.connectionSettings));
    }

    protected List<String> getSuffixesOfBranch(String branchOid) {
        ArrayList<String> suffixes = new ArrayList<String>();
        String prefix = branchOid + ".";
        Map<OID, Variable> branch = this.getRowsStartingWith(branchOid);
        for (OID oid : branch.keySet()) {
            String suffix = oid.toDottedString().substring(prefix.length());
            if (suffix.isEmpty()) continue;
            suffixes.add(suffix);
        }
        return suffixes;
    }

    protected Map<OID, Variable> getRowsStartingWith(String prefixOid) {
        HashMap<OID, Variable> rows = new HashMap<OID, Variable>();
        for (OID oid : this.table.keySet()) {
            if (!oid.toDottedString().startsWith(prefixOid + ".")) continue;
            rows.put(oid, this.table.get(oid));
        }
        return rows;
    }

    protected Variable get(String oid) {
        for (OID key : this.table.keySet()) {
            if (!key.toDottedString().equals(oid)) continue;
            return this.table.get(key);
        }
        return null;
    }

    protected Variable get(String ... oids) {
        StringJoiner joiner = new StringJoiner(".");
        for (String oid : oids) {
            joiner.add(oid);
        }
        return this.get(joiner.toString());
    }

    protected boolean isNull(Variable variable) {
        return variable == null || variable instanceof Null;
    }

    protected boolean isNullOrEmpty(Variable variable) {
        return this.isNull(variable) || variable.toString().isEmpty();
    }
}

