/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.util.SNMPTableReader;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;

public class IpAdIfTableReader
extends SNMPTableReader {
    private static final String LOG_CONTEXT = IpAdIfTableReader.class.getSimpleName();
    private static final String ipAdIfTable = "1.3.6.1.2.1.4.20.1.2";

    public IpAdIfTableReader(SNMPConnectionSettings connectionSettings) {
        super(connectionSettings);
        this.readTable(ipAdIfTable);
    }

    public Map<Integer, List<String>> getAddresses() {
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        for (OID key : this.table.keySet()) {
            String ip = key.toDottedString().substring(ipAdIfTable.length() + 1);
            int ifIndex = ((Variable)this.table.get(key)).toInt();
            if (!map.containsKey(ifIndex)) {
                map.put(ifIndex, new ArrayList());
            }
            List<String> addresses = map.get(ifIndex);
            addresses.add(ip);
        }
        return map;
    }
}

