/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.Interface;
import ru.kirillius.net.graph.InterfaceType;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.util.IpAdIfTableReader;
import ru.kirillius.net.graph.util.SNMPTableReader;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;

public class IfTableReader
extends SNMPTableReader {
    private final IpAdIfTableReader ipAdIfTableReader;

    public IfTableReader(SNMPConnectionSettings connectionSettings) {
        super(connectionSettings);
        this.readTable("1.3.6.1.2.1.2.2.1.1");
        this.readTable("1.3.6.1.2.1.2.2.1.6");
        this.readTable("1.3.6.1.2.1.31");
        this.readTable("1.3.6.1.2.1.2.2.1.3");
        this.ipAdIfTableReader = new IpAdIfTableReader(connectionSettings);
    }

    public List<Interface> getInterfaces() {
        ArrayList<Interface> list = new ArrayList<Interface>();
        Map<Integer, List<String>> addresses = this.ipAdIfTableReader.getAddresses();
        for (Integer index : this.getSuffixesOfBranch("1.3.6.1.2.1.2.2.1.1").stream().map(Integer::parseInt).collect(Collectors.toList())) {
            Interface iface = new Interface(index);
            Variable ifType = this.get("1.3.6.1.2.1.2.2.1.3", index.toString());
            iface.setType(this.isNull(ifType) ? InterfaceType.unsupported : InterfaceType.getByType(ifType.toInt()));
            Variable ifName = this.get("1.3.6.1.2.1.31.1.1.1.1", index.toString());
            iface.setName(this.isNull(ifName) ? "" : ifName.toString());
            Variable ifMac = this.get("1.3.6.1.2.1.2.2.1.6", index.toString());
            iface.setMac(this.isNullOrEmpty(ifMac) ? MacAddress.NullMac : new MacAddress(ifMac.toString()));
            iface.setAddresses(addresses.getOrDefault(index, Collections.emptyList()));
            list.add(iface);
        }
        return list;
    }
}

