/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.util;

import java.io.IOException;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.NetworkDevice;
import ru.kirillius.net.graph.util.IfTableReader;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;
import ru.kirillius.snmp.tools.SNMPService;
import ru.kirillius.utils.logging.SystemLogger;

public class DeviceInfoReader {
    private static final String LOG_CONTEXT = DeviceInfoReader.class.getSimpleName();
    public static final String sysNameOid = "1.3.6.1.2.1.1.5.0";
    public static final String sysDescrOid = "1.3.6.1.2.1.1.1.0";
    private final SNMPConnectionSettings settings;

    public DeviceInfoReader(SNMPConnectionSettings settings) {
        this.settings = settings;
    }

    public void configureDevice(NetworkDevice device) {
        SNMPService snmp = SNMPService.getInstance();
        try {
            Variable sysName = snmp.get(sysNameOid, this.settings);
            if (sysName == null || sysName instanceof Null) {
                throw new RuntimeException("null value");
            }
            device.setSysName(sysName.toString());
        }
        catch (IOException e) {
            SystemLogger.error((String)("Unable to detect sysName for device " + device.getManagementAddress()), (String)LOG_CONTEXT, (Throwable)e);
        }
        try {
            Variable sysDescr = snmp.get(sysDescrOid, this.settings);
            if (sysDescr == null || sysDescr instanceof Null) {
                throw new RuntimeException("null value");
            }
            device.setSysDescr(sysDescr.toString());
        }
        catch (IOException e) {
            SystemLogger.error((String)("Unable to detect sysDescr for device " + device.getManagementAddress()), (String)LOG_CONTEXT, (Throwable)e);
        }
        this.discoverInterfaces(device, this.settings);
    }

    private void discoverInterfaces(NetworkDevice device, SNMPConnectionSettings settings) {
        IfTableReader ifTableReader = new IfTableReader(settings);
        device.setInterfaces(ifTableReader.getInterfaces());
    }
}

