/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import ru.kirillius.net.graph.AbstractNeighborshipProvider;
import ru.kirillius.net.graph.Connection;
import ru.kirillius.net.graph.DeviceContext;
import ru.kirillius.net.graph.DiscoverProtocol;
import ru.kirillius.net.graph.Interface;
import ru.kirillius.net.graph.LLDP.LLDPConnectionProvider;
import ru.kirillius.net.graph.MNDP.MNDPConnectionProvider;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.NeighborshipProvider;
import ru.kirillius.net.graph.NetworkDevice;
import ru.kirillius.net.graph.NetworkGraph;
import ru.kirillius.net.graph.ProtocolBinding;
import ru.kirillius.net.graph.util.DeviceInfoReader;
import ru.kirillius.net.graph.util.Tuple;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;
import ru.kirillius.utils.logging.SystemLogger;

public class NetworkGraphBuilder {
    private static final Collection<Class<? extends AbstractNeighborshipProvider>> availableProviders = Arrays.asList(LLDPConnectionProvider.class, MNDPConnectionProvider.class);
    private static final String LOG_CONTEXT = NetworkGraphBuilder.class.getSimpleName();
    private final Collection<Class<? extends AbstractNeighborshipProvider>> selectedProviders;
    private final ExecutorService pool;
    private final boolean exportNewDevices;

    public NetworkGraphBuilder(int threadCount, List<DiscoverProtocol> protocols, boolean exportNewDevices) {
        this.exportNewDevices = exportNewDevices;
        if (protocols == null || protocols.size() == 0) {
            throw new IllegalStateException("At least one protocol have to be set");
        }
        if (threadCount <= 0) {
            throw new IllegalArgumentException("Count must be > 0");
        }
        this.selectedProviders = new ArrayList<Class<? extends AbstractNeighborshipProvider>>();
        for (Class<? extends AbstractNeighborshipProvider> providerClass : availableProviders) {
            ProtocolBinding binding = providerClass.getAnnotation(ProtocolBinding.class);
            if (binding == null || !protocols.contains((Object)binding.value())) continue;
            this.selectedProviders.add(providerClass);
        }
        this.pool = Executors.newFixedThreadPool(threadCount);
    }

    public NetworkGraph buildForDevices(Collection<SNMPConnectionSettings> devices) {
        NetworkGraph graph = new NetworkGraph();
        Collection<NetworkDevice> discoveredDevices = this.discoverDevices(devices);
        for (NetworkDevice device : discoveredDevices) {
            graph.addDevice(device);
        }
        Tuple<Collection<Connection>, Collection<NetworkDevice>> result = this.discoverConnections(discoveredDevices);
        for (NetworkDevice device : result.getSecond()) {
            graph.addDevice(device);
        }
        for (Connection connection : result.getFirst()) {
            graph.addConnection(connection);
        }
        return graph;
    }

    private <T extends Runnable> void waitForCompletionOfTasks(Class<T> taskClass, Map<T, Future<?>> tasks) {
        while (!tasks.values().stream().allMatch(Future::isDone)) {
            SystemLogger.debug((String)("Waiting for completion of " + tasks.values().stream().filter(future -> !future.isDone()).count() + " " + taskClass.getSimpleName()), (String)LOG_CONTEXT);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                for (Future<?> value : tasks.values()) {
                    value.cancel(true);
                }
                throw new RuntimeException(e);
            }
        }
    }

    private Interface findSameInterface(Collection<Interface> interfaces, Interface iface) {
        Interface foundIf;
        if (!iface.getName().isEmpty() && (foundIf = (Interface)interfaces.stream().filter(anInterface -> anInterface.getName().equals(iface.getName())).findFirst().orElse(null)) != null) {
            return foundIf;
        }
        if (!iface.getMac().equals(MacAddress.NullMac)) {
            return interfaces.stream().filter(anInterface -> anInterface.getMac().equals(iface.getMac())).findFirst().orElse(null);
        }
        return null;
    }

    private NetworkDevice findSameDevice(Collection<NetworkDevice> devices, NetworkDevice device) {
        NetworkDevice foundDevice;
        if (!device.getSystemMacAddress().equals(MacAddress.NullMac) && (foundDevice = (NetworkDevice)devices.stream().filter(item -> item.getSystemMacAddress().equals(device.getSystemMacAddress())).findFirst().orElse(null)) != null) {
            return foundDevice;
        }
        if (!device.getManagementAddress().equals("0.0.0.0")) {
            return devices.stream().filter(item -> item.getManagementAddress().equals(device.getManagementAddress()) || item.getInterfaces().stream().anyMatch(anInterface -> anInterface.getAddresses().contains(device.getManagementAddress()))).findFirst().orElse(null);
        }
        return null;
    }

    private Tuple<Collection<Connection>, Collection<NetworkDevice>> discoverConnections(Collection<NetworkDevice> devices) {
        HashMap tasks = new HashMap();
        for (NetworkDevice device : devices) {
            DeviceConnectionDiscoverTask task = new DeviceConnectionDiscoverTask(device, this.instantiateProviders(device, devices));
            tasks.put(task, this.pool.submit(task));
        }
        this.waitForCompletionOfTasks(DeviceConnectionDiscoverTask.class, tasks);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ArrayList<NetworkDevice> foundDevices = new ArrayList<NetworkDevice>();
        for (DeviceConnectionDiscoverTask task : tasks.keySet()) {
            for (NetworkDevice foundDevice : task.getFoundDevices()) {
                NetworkDevice sameDevice = this.findSameDevice(foundDevices, foundDevice);
                if (sameDevice != null) {
                    for (Connection foundConnection : task.getFoundConnections()) {
                        if (!foundConnection.getRemote().equals(foundDevice)) continue;
                        foundConnection.setRemote(sameDevice);
                        Interface sameIface = this.findSameInterface(sameDevice.getInterfaces(), foundConnection.getRemotePort());
                        if (sameIface == null) {
                            sameDevice.getInterfaces().add(foundConnection.getRemotePort());
                            continue;
                        }
                        foundConnection.setRemotePort(sameIface);
                    }
                    continue;
                }
                foundDevices.add(foundDevice);
            }
            for (Connection foundConnection : task.getFoundConnections()) {
                boolean hasSame = connections.stream().anyMatch(connection -> connection.isSame(foundConnection));
                if (hasSame) continue;
                connections.add(foundConnection);
            }
        }
        if (!this.exportNewDevices) {
            ArrayList<Connection> connectionsToRemove = new ArrayList<Connection>();
            for (Connection connection2 : connections) {
                if (!foundDevices.contains(connection2.getRemote()) && !foundDevices.contains(connection2.getLocal())) continue;
                connectionsToRemove.add(connection2);
            }
            foundDevices.clear();
            connections.removeAll(connectionsToRemove);
        }
        return new Tuple<Collection<Connection>, Collection<NetworkDevice>>(connections, foundDevices);
    }

    private Collection<NetworkDevice> discoverDevices(Collection<SNMPConnectionSettings> devices) {
        HashMap tasks = new HashMap();
        for (SNMPConnectionSettings settings : devices) {
            DeviceDiscoverTask task = new DeviceDiscoverTask(settings);
            tasks.put(task, this.pool.submit(task));
        }
        this.waitForCompletionOfTasks(DeviceDiscoverTask.class, tasks);
        ArrayList<NetworkDevice> result = new ArrayList<NetworkDevice>();
        for (DeviceDiscoverTask task : tasks.keySet()) {
            if (task.getDevice() == null) continue;
            result.add(task.getDevice());
        }
        return result;
    }

    private Collection<NeighborshipProvider> instantiateProviders(NetworkDevice device, Collection<NetworkDevice> devices) {
        ArrayList<NeighborshipProvider> providers = new ArrayList<NeighborshipProvider>();
        for (Class<? extends AbstractNeighborshipProvider> providerClass : this.selectedProviders) {
            providers.add(this.instantiateProvider(providerClass, device, devices));
        }
        return providers;
    }

    private NeighborshipProvider instantiateProvider(Class<? extends AbstractNeighborshipProvider> providerClass, NetworkDevice device, Collection<NetworkDevice> devices) {
        try {
            Constructor<? extends AbstractNeighborshipProvider> constructor = providerClass.getConstructor(NetworkDevice.class, Collection.class);
            return constructor.newInstance(device, devices);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate provider " + providerClass.getSimpleName(), e);
        }
    }

    private static class DeviceDiscoverTask
    implements Runnable {
        private static final String LOG_CONTEXT = DeviceDiscoverTask.class.getSimpleName();
        private final SNMPConnectionSettings settings;
        private NetworkDevice device = null;

        public SNMPConnectionSettings getSettings() {
            return this.settings;
        }

        public DeviceDiscoverTask(SNMPConnectionSettings settings) {
            this.settings = settings;
        }

        public NetworkDevice getDevice() {
            return this.device;
        }

        @Override
        public void run() {
            String managementAddress = this.settings.toTarget().getAddress().toString().split(Pattern.quote("/"))[0];
            this.device = new NetworkDevice(managementAddress);
            SystemLogger.debug((String)("Reading interfaces of " + this.device.getManagementAddress()), (String)LOG_CONTEXT);
            DeviceInfoReader infoReader = new DeviceInfoReader(this.settings);
            infoReader.configureDevice(this.device);
            DeviceContext context = new DeviceContext();
            context.setConnectionSettings(this.settings);
            this.device.setContext(context);
        }
    }

    private static class DeviceConnectionDiscoverTask
    implements Runnable {
        private final NetworkDevice device;
        private static final String LOG_CONTEXT = DeviceConnectionDiscoverTask.class.getSimpleName();
        private final Collection<NeighborshipProvider> providers;
        private final Collection<Connection> foundConnections = new ArrayList<Connection>();
        private final Collection<NetworkDevice> foundDevices = new ArrayList<NetworkDevice>();

        public DeviceConnectionDiscoverTask(NetworkDevice device, Collection<NeighborshipProvider> providers) {
            this.device = device;
            this.providers = providers;
        }

        public Collection<Connection> getFoundConnections() {
            return this.foundConnections;
        }

        public Collection<NetworkDevice> getFoundDevices() {
            return this.foundDevices;
        }

        @Override
        public void run() {
            for (NeighborshipProvider provider : this.providers) {
                SystemLogger.debug((String)("Discovering neighbors of " + this.device.getManagementAddress() + " using provider " + provider.getClass().getSimpleName()), (String)LOG_CONTEXT);
                provider.configure();
                Tuple<Collection<Connection>, Collection<NetworkDevice>> result = provider.discover();
                this.foundDevices.addAll(result.getSecond());
                this.foundConnections.addAll(result.getFirst());
            }
        }
    }
}

