/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.kirillius.net.graph.Connection;
import ru.kirillius.net.graph.NetworkDevice;

public class NetworkGraph {
    private final Set<NetworkDevice> devices = new HashSet<NetworkDevice>();
    private final List<Connection> connections = new ArrayList<Connection>();

    public List<NetworkDevice> getDevices() {
        return new ArrayList<NetworkDevice>(this.devices);
    }

    public List<Connection> getConnections() {
        return new ArrayList<Connection>(this.connections);
    }

    public void addDevice(NetworkDevice device) {
        this.devices.add(device);
    }

    public void addConnection(Connection connection) {
        boolean exist = this.getConnectionsBetween(connection.getLocal(), connection.getRemote()).stream().anyMatch(existing -> existing.getLocal().equals(connection.getLocal()) && existing.getLocalPort().equals(connection.getLocalPort()) && existing.getRemotePort().equals(connection.getRemotePort()) || existing.getRemote().equals(connection.getLocal()) && existing.getRemotePort().equals(connection.getLocalPort()) && existing.getLocalPort().equals(connection.getRemotePort()));
        if (!exist) {
            this.connections.add(connection);
        }
    }

    public List<Connection> getConnectionsForDevice(NetworkDevice device) {
        return this.connections.stream().filter(connection -> connection.getLocal().equals(device) || connection.getRemote().equals(device)).collect(Collectors.toUnmodifiableList());
    }

    public List<Connection> getConnectionsBetween(NetworkDevice a, NetworkDevice b) {
        return this.connections.stream().filter(connection -> connection.getLocal() == a && connection.getRemote() == b || connection.getLocal() == b && connection.getRemote() == a).collect(Collectors.toUnmodifiableList());
    }
}

