/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.MNDP;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.MNDP.MNDPTableEntry;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.util.SNMPTableReader;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;

public class MNDPTableReader
extends SNMPTableReader {
    private static final String MNDP_ROOT = "1.3.6.1.4.1.14988.1.1.11";
    private static final String LLDP_REMPORTID = "1.0.8802.1.1.2.1.4.1.1.7";
    private static final String MNDP_REMOTE_IP = "1.3.6.1.4.1.14988.1.1.11.1.1.2";
    private static final String MNDP_REMOTE_MAC = "1.3.6.1.4.1.14988.1.1.11.1.1.3";
    private static final String MNDP_SYSNAME = "1.3.6.1.4.1.14988.1.1.11.1.1.6";
    private static final String MNDP_PLATFORM = "1.3.6.1.4.1.14988.1.1.11.1.1.5";
    private static final String MNDP_LOCAL_IF = "1.3.6.1.4.1.14988.1.1.11.1.1.8";
    public static final String MIKROTIK_PLATFORM = "MikroTik";

    public MNDPTableReader(SNMPConnectionSettings connectionSettings) {
        super(connectionSettings);
        this.readTable(MNDP_ROOT);
        this.readTable(LLDP_REMPORTID);
    }

    public List<MNDPTableEntry> readNeighborsTable() {
        ArrayList<MNDPTableEntry> list = new ArrayList<MNDPTableEntry>();
        for (String entryId : this.getSuffixesOfBranch(MNDP_REMOTE_IP)) {
            MNDPTableEntry entry = new MNDPTableEntry();
            String platform = this.get(MNDP_PLATFORM, entryId).toString();
            if (!platform.equals(MIKROTIK_PLATFORM)) continue;
            entry.setRemoteIpAddress(this.get(MNDP_REMOTE_IP, entryId).toString());
            entry.setLocalInterfaceIndex(this.get(MNDP_LOCAL_IF, entryId).toInt());
            entry.setRemoteSysName(this.get(MNDP_SYSNAME, entryId).toString());
            entry.setRemoteMac(new MacAddress(this.get(MNDP_REMOTE_MAC, entryId).toString()));
            entry.setRemoteIfName(this.searchRemoteIfName(entryId));
            list.add(entry);
        }
        return list;
    }

    private String searchRemoteIfName(String entryid) {
        Map<OID, Variable> portIds = this.getRowsStartingWith(LLDP_REMPORTID);
        for (OID key : portIds.keySet()) {
            if (!key.toDottedString().endsWith("." + entryid)) continue;
            return portIds.get(key).toString();
        }
        return "";
    }
}

