/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.MNDP;

import java.util.ArrayList;
import java.util.Collection;
import ru.kirillius.net.graph.AbstractNeighborshipProvider;
import ru.kirillius.net.graph.Connection;
import ru.kirillius.net.graph.DiscoverProtocol;
import ru.kirillius.net.graph.Interface;
import ru.kirillius.net.graph.MNDP.MNDPTableEntry;
import ru.kirillius.net.graph.MNDP.MNDPTableReader;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.NetworkDevice;
import ru.kirillius.net.graph.ProtocolBinding;
import ru.kirillius.net.graph.util.Tuple;
import ru.kirillius.utils.logging.SystemLogger;

@ProtocolBinding(value=DiscoverProtocol.MNDP)
public class MNDPConnectionProvider
extends AbstractNeighborshipProvider {
    public static final String LOG_CONTEXT = MNDPConnectionProvider.class.getSimpleName();

    public MNDPConnectionProvider(NetworkDevice device, Collection<NetworkDevice> devices) {
        super(device, devices);
    }

    @Override
    public void configure() {
    }

    @Override
    public Tuple<Collection<Connection>, Collection<NetworkDevice>> discover() {
        MNDPTableReader reader = new MNDPTableReader(this.device.getContext().getConnectionSettings());
        ArrayList<Connection> foundConnections = new ArrayList<Connection>();
        ArrayList<NetworkDevice> foundDevices = new ArrayList<NetworkDevice>();
        for (MNDPTableEntry entry : reader.readNeighborsTable()) {
            try {
                Interface remotePort;
                Interface localPort = this.device.getInterfaces().stream().filter(anInterface -> anInterface.getIndex() == entry.getLocalInterfaceIndex()).findFirst().orElse(null);
                if (localPort == null) {
                    throw new RuntimeException("Unable to find local port with index " + entry.getLocalInterfaceIndex());
                }
                MacAddress remoteMac = entry.getRemoteMac();
                NetworkDevice remoteDevice = this.findDeviceByMacAddress(remoteMac);
                if (remoteDevice == null) {
                    remoteDevice = this.findDeviceByIpAddress(entry.getRemoteIpAddress());
                }
                if (remoteDevice == null) {
                    remoteDevice = this.createDeviceFromEntry(entry);
                    foundDevices.add(remoteDevice);
                }
                if ((remotePort = this.findInterfaceByName(entry.getRemoteIfName(), remoteDevice)) == null) {
                    remotePort = this.createInterfaceFromEntry(entry);
                    remoteDevice.getInterfaces().add(remotePort);
                }
                Connection connection = new Connection(this.device, remoteDevice);
                connection.setRemotePort(remotePort);
                connection.setLocalPort(localPort);
                foundConnections.add(connection);
            }
            catch (Throwable t) {
                SystemLogger.error((String)"Unable to detect connection from MNDP table entry", (String)LOG_CONTEXT, (Throwable)t);
            }
        }
        return new Tuple<Collection<Connection>, Collection<NetworkDevice>>(foundConnections, foundDevices);
    }

    private Interface createInterfaceFromEntry(MNDPTableEntry entry) {
        Interface iface = new Interface(0);
        iface.setName(entry.getRemoteIfName());
        iface.setMac(entry.getRemoteMac());
        return iface;
    }

    private NetworkDevice createDeviceFromEntry(MNDPTableEntry entry) {
        NetworkDevice device = new NetworkDevice(entry.getRemoteIpAddress());
        device.setSystemMacAddress(entry.getRemoteMac());
        return device;
    }
}

