/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.LLDP;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.LLDP.ChassisIdSubtype;
import ru.kirillius.net.graph.LLDP.LLDPTableEntry;
import ru.kirillius.net.graph.LLDP.PortType;
import ru.kirillius.net.graph.util.SNMPTableReader;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;
import ru.kirillius.utils.logging.SystemLogger;

public class LLDPTableReader
extends SNMPTableReader {
    private static final String LOG_CONTEXT = LLDPTableReader.class.getSimpleName();
    private static final String lldpObjects = "1.0.8802.1.1.2.1";
    private static final String lldpRemTable = "1.0.8802.1.1.2.1.4.1.1";
    private static final String lldpLocPortId = "1.0.8802.1.1.2.1.3.7.1.3";
    private static final String lldpLocChassisId = "1.0.8802.1.1.2.1.3.2";
    private static final String lldpRemChassisIdSubtype = "1.0.8802.1.1.2.1.4.1.1.4";
    private static final String lldpRemChassisId = "1.0.8802.1.1.2.1.4.1.1.5";
    private static final String lldpRemPortIdSubtype = "1.0.8802.1.1.2.1.4.1.1.6";
    private static final String lldpRemPortId = "1.0.8802.1.1.2.1.4.1.1.7";
    private static final String lldpRemPortDesc = "1.0.8802.1.1.2.1.4.1.1.8";
    private static final String lldpRemSysName = "1.0.8802.1.1.2.1.4.1.1.9";
    private static final String lldpRemSysDesc = "1.0.8802.1.1.2.1.4.1.1.10";
    private static final String lldpLocTablePortId = "1.0.8802.1.1.2.1.3.7.1.3";
    private static final String lldpLocTablePortSubtype = "1.0.8802.1.1.2.1.3.7.1.2";

    public LLDPTableReader(SNMPConnectionSettings connectionSettings) {
        super(connectionSettings);
        this.readTable(lldpRemTable);
        this.readTable("1.0.8802.1.1.2.1.3.7.1.3");
        this.readTable(lldpLocTablePortSubtype);
    }

    public List<LLDPTableEntry> readRemoteTable() {
        ArrayList<LLDPTableEntry> neighbors = new ArrayList<LLDPTableEntry>();
        List<String> entries = this.getSuffixesOfBranch(lldpRemChassisIdSubtype);
        for (String entryId : entries) {
            String[] split = entryId.split(Pattern.quote("."));
            if (split.length != 3) {
                SystemLogger.error((String)("Invalid LLDP entry id: 1.0.8802.1.1.2.1.4.1.1.4." + entryId), (String)LOG_CONTEXT);
                continue;
            }
            LLDPTableEntry entry = new LLDPTableEntry();
            String localIfEntryNumber = split[1];
            entry.setLocalPortId(this.get("1.0.8802.1.1.2.1.3.7.1.3", localIfEntryNumber).toString());
            entry.setLocalPortType(PortType.getByType(this.get(lldpLocTablePortSubtype, localIfEntryNumber).toInt()));
            Variable chassisIdSubtype = this.get(lldpRemChassisIdSubtype, entryId);
            if (this.isNull(chassisIdSubtype)) {
                SystemLogger.message((String)"LLDP: Skipping device without chassisId", (String)LOG_CONTEXT);
                continue;
            }
            entry.setRemoteChassisIdSubtype(ChassisIdSubtype.getByType(chassisIdSubtype.toInt()));
            Variable remoteChassisMac = this.get(lldpRemChassisId, entryId);
            if (this.isNull(remoteChassisMac)) {
                SystemLogger.message((String)"LLDP: ChassisId is empty for device ", (String)LOG_CONTEXT);
                continue;
            }
            entry.setRemoteChassisId(remoteChassisMac.toString());
            Variable portType = this.get(lldpRemPortIdSubtype, entryId);
            if (!this.isNull(portType)) {
                entry.setRemotePortType(PortType.getByType(portType.toInt()));
                Variable portId = this.get(lldpRemPortId, entryId);
                if (!this.isNull(portId)) {
                    entry.setRemotePortId(portId.toString());
                } else {
                    entry.setRemotePortId("");
                }
            } else {
                entry.setRemotePortType(PortType.unsupported);
                entry.setRemotePortId("");
            }
            Variable portDesc = this.get(lldpRemPortDesc, entryId);
            entry.setRemotePortDesc(!this.isNull(portDesc) ? portDesc.toString() : "");
            Variable sysName = this.get(lldpRemSysName, entryId);
            entry.setRemoteSysName(!this.isNull(sysName) ? sysName.toString() : "");
            Variable sysDesc = this.get(lldpRemSysDesc, entryId);
            entry.setRemoteSysDesc(!this.isNull(sysDesc) ? sysDesc.toString() : "");
            neighbors.add(entry);
        }
        return neighbors;
    }
}

