/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph.LLDP;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.Variable;
import ru.kirillius.net.graph.AbstractNeighborshipProvider;
import ru.kirillius.net.graph.Connection;
import ru.kirillius.net.graph.DiscoverProtocol;
import ru.kirillius.net.graph.Interface;
import ru.kirillius.net.graph.InterfaceType;
import ru.kirillius.net.graph.LLDP.ChassisIdSubtype;
import ru.kirillius.net.graph.LLDP.LLDPTableEntry;
import ru.kirillius.net.graph.LLDP.LLDPTableReader;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.NetworkDevice;
import ru.kirillius.net.graph.ProtocolBinding;
import ru.kirillius.net.graph.util.Tuple;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;
import ru.kirillius.snmp.tools.SNMPService;
import ru.kirillius.utils.logging.SystemLogger;

@ProtocolBinding(value=DiscoverProtocol.LLDP)
public class LLDPConnectionProvider
extends AbstractNeighborshipProvider {
    private static final String LOG_CONTEXT = LLDPConnectionProvider.class.getSimpleName();
    public static final String lldpLocChassisSubtype = "1.0.8802.1.1.2.1.3.1.0";
    public static final String lldpLocChassisId = "1.0.8802.1.1.2.1.3.2.0";

    public LLDPConnectionProvider(NetworkDevice device, Collection<NetworkDevice> devices) {
        super(device, devices);
    }

    @Override
    public void configure() {
        SNMPService snmp = SNMPService.getInstance();
        SNMPConnectionSettings settings = this.device.getContext().getConnectionSettings();
        try {
            Variable chassisIdSubtype = snmp.get(lldpLocChassisSubtype, settings);
            if (chassisIdSubtype == null || chassisIdSubtype instanceof Null) {
                throw new RuntimeException("ChassisIdSubtype is null");
            }
            ChassisIdSubtype type = ChassisIdSubtype.getByType(chassisIdSubtype.toInt());
            switch (type) {
                case macAddress: {
                    Variable locChassisId = snmp.get(lldpLocChassisId, settings);
                    if (locChassisId == null || locChassisId instanceof Null) {
                        throw new RuntimeException("chassisId is null");
                    }
                    this.device.setSystemMacAddress(new MacAddress(locChassisId.toString()));
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported chassisId type " + type);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            SystemLogger.error((String)("Unable to detect chassisIdSubtype for device " + this.device.getManagementAddress()), (String)LOG_CONTEXT, (Throwable)e);
        }
    }

    @Override
    public Tuple<Collection<Connection>, Collection<NetworkDevice>> discover() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ArrayList<NetworkDevice> foundDevices = new ArrayList<NetworkDevice>();
        LLDPTableReader lldpTableReader = new LLDPTableReader(this.device.getContext().getConnectionSettings());
        for (LLDPTableEntry entry : lldpTableReader.readRemoteTable()) {
            try {
                Interface localPort;
                Interface remotePort;
                NetworkDevice remoteDevice = this.findDevice(entry.getRemoteChassisIdSubtype(), entry.getRemoteChassisId());
                if (remoteDevice == null) {
                    remoteDevice = this.createNetworkDeviceFromEntryInfo(entry);
                    foundDevices.add(remoteDevice);
                }
                if ((remotePort = this.findInterfaceByPortType(entry.getRemotePortType(), entry.getRemotePortId(), remoteDevice)) == null) {
                    remotePort = this.createInterfaceFromEntryInfo(entry);
                    remoteDevice.getInterfaces().add(remotePort);
                }
                if ((localPort = this.findInterfaceByPortType(entry.getLocalPortType(), entry.getLocalPortId(), this.device)) == null) {
                    throw new RuntimeException("Unable to find local port with id " + entry.getLocalPortId());
                }
                Connection connection = new Connection(this.device, remoteDevice);
                connection.setLocalPort(localPort);
                connection.setRemotePort(remotePort);
                connections.add(connection);
            }
            catch (Throwable t) {
                SystemLogger.error((String)"Unable to detect connection from lldp table entry", (String)LOG_CONTEXT, (Throwable)t);
            }
        }
        return new Tuple<Collection<Connection>, Collection<NetworkDevice>>(connections, foundDevices);
    }

    private Interface createInterfaceFromEntryInfo(LLDPTableEntry entry) {
        Interface iface = new Interface(0);
        iface.setType(InterfaceType.other);
        String id = entry.getRemotePortId();
        iface.setName(entry.getRemotePortType().name() + "(" + id + ")");
        switch (entry.getRemotePortType()) {
            case macAddress: {
                iface.setMac(new MacAddress(id));
                break;
            }
            case networkAddress: {
                iface.getAddresses().add(id);
                break;
            }
            case interfaceName: {
                iface.setName(id);
                break;
            }
        }
        return iface;
    }

    private NetworkDevice createNetworkDeviceFromEntryInfo(LLDPTableEntry entry) {
        NetworkDevice device = new NetworkDevice("0.0.0.0");
        device.setSysName(entry.getRemoteSysName());
        device.setSysDescr(entry.getRemoteSysDesc());
        String id = entry.getRemoteChassisId();
        switch (entry.getRemoteChassisIdSubtype()) {
            case macAddress: {
                device.setSystemMacAddress(new MacAddress(id));
                break;
            }
            case networkAddress: {
                device.setManagementAddress(id);
            }
        }
        return device;
    }

    private NetworkDevice findDevice(ChassisIdSubtype type, String chassisId) {
        switch (type) {
            case macAddress: {
                return this.findDeviceByMacAddress(new MacAddress(chassisId));
            }
            case networkAddress: {
                return this.findDeviceByIpAddress(chassisId);
            }
        }
        SystemLogger.message((String)("LLDP chassisId subtype" + type + " is unsupported now"), (String)LOG_CONTEXT);
        return null;
    }
}

