/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ru.kirillius.net.graph.InterfaceType;
import ru.kirillius.net.graph.MacAddress;

public class Interface {
    private final int index;
    private MacAddress mac = MacAddress.NullMac;
    private String name = "";
    private InterfaceType type = InterfaceType.unsupported;
    private List<String> addresses = Collections.emptyList();

    public InterfaceType getType() {
        return this.type;
    }

    public void setType(InterfaceType type) {
        this.type = type;
    }

    public Interface(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interface that = (Interface)o;
        return this.index == that.index && Objects.equals(this.mac, that.mac) && Objects.equals(this.name, that.name) && Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.mac, this.name, this.addresses);
    }

    public String toString() {
        return "NetworkDeviceInterface{" + this.mac + "," + this.name + "}";
    }

    public Interface(int index, MacAddress mac, String name, List<String> addresses) {
        this.index = index;
        this.mac = mac;
        this.name = name;
        this.addresses = addresses;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MacAddress getMac() {
        return this.mac;
    }

    public void setMac(MacAddress mac) {
        this.mac = mac;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }
}

