/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.net.graph;

import java.util.Collection;
import ru.kirillius.net.graph.Interface;
import ru.kirillius.net.graph.InterfaceType;
import ru.kirillius.net.graph.LLDP.PortType;
import ru.kirillius.net.graph.MacAddress;
import ru.kirillius.net.graph.NeighborshipProvider;
import ru.kirillius.net.graph.NetworkDevice;

public abstract class AbstractNeighborshipProvider
implements NeighborshipProvider {
    protected final NetworkDevice device;
    protected final Collection<NetworkDevice> devices;

    public AbstractNeighborshipProvider(NetworkDevice device, Collection<NetworkDevice> devices) {
        this.device = device;
        this.devices = devices;
    }

    protected NetworkDevice findDeviceByMacAddress(MacAddress address) {
        if (address.equals(MacAddress.NullMac)) {
            return null;
        }
        for (NetworkDevice device : this.devices) {
            if (device.getSystemMacAddress().equals(address)) {
                return device;
            }
            for (Interface anInterface : device.getInterfaces()) {
                if (!anInterface.getMac().equals(address)) continue;
                return device;
            }
        }
        return null;
    }

    protected Interface findInterfaceByPortType(PortType type, String id, NetworkDevice device) {
        switch (type) {
            case macAddress: {
                MacAddress matchMac = new MacAddress(id);
                if (matchMac.equals(MacAddress.NullMac)) {
                    return null;
                }
                return device.getInterfaces().stream().filter(iface -> iface.getMac().equals(matchMac)).min((a, b) -> {
                    boolean eb;
                    boolean ea = a.getType().equals((Object)InterfaceType.ethernetCsmacd);
                    return ea == (eb = b.getType().equals((Object)InterfaceType.ethernetCsmacd)) ? 0 : (ea ? -1 : 1);
                }).orElse(null);
            }
            case networkAddress: {
                return device.getInterfaces().stream().filter(networkDeviceInterface -> networkDeviceInterface.getAddresses().contains(id)).findFirst().orElse(null);
            }
            case interfaceName: {
                String name = id;
                int offset = name.lastIndexOf(47);
                if (offset > -1) {
                    name = name.substring(offset + 1);
                }
                String match = name;
                return device.getInterfaces().stream().filter(networkDeviceInterface -> networkDeviceInterface.getName().equals(match) || networkDeviceInterface.getName().equals(id)).findFirst().orElse(null);
            }
        }
        return null;
    }

    protected Interface findInterfaceByName(String id, NetworkDevice device) {
        String name = id;
        int offset = name.lastIndexOf(47);
        if (offset > -1) {
            name = name.substring(offset + 1);
        }
        String filteredName = name;
        return device.getInterfaces().stream().filter(anInterface -> anInterface.getName().equals(id) || anInterface.getName().equals(filteredName)).findFirst().orElse(null);
    }

    protected NetworkDevice findDeviceByIpAddress(String address) {
        for (NetworkDevice device : this.devices) {
            if (device.getManagementAddress().equals(address)) {
                return device;
            }
            for (Interface anInterface : device.getInterfaces()) {
                for (String interfaceAddress : anInterface.getAddresses()) {
                    if (!interfaceAddress.equals(address)) continue;
                    return device;
                }
            }
        }
        return null;
    }
}

