/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.rpc.Servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import ru.kirillius.java.utils.events.ConcurrentEventHandler;
import ru.kirillius.java.utils.events.EventHandler;
import ru.kirillius.json.DefaultPropertySerializer;
import ru.kirillius.json.JSONSerializable;
import ru.kirillius.json.JSONSerializer;
import ru.kirillius.json.JSONUtility;
import ru.kirillius.json.rpc.Annotations.JRPCArgument;
import ru.kirillius.json.rpc.Annotations.JRPCContext;
import ru.kirillius.json.rpc.Annotations.JRPCMethod;
import ru.kirillius.json.rpc.CodeGeneration.JSCodeGenerator;
import ru.kirillius.json.rpc.ReflectionUtils;
import ru.kirillius.json.rpc.Servlet.CallContext;
import ru.kirillius.json.rpc.Servlet.MethodCall;
import ru.kirillius.json.rpc.Servlet.RequestHandler;

public final class JSONRPCServlet
extends HttpServlet {
    public static final String CONTEXT_PATH = "/jsonrpc/*";
    private static final AtomicReference<String> cachedSource = new AtomicReference<Object>(null);
    private static final Set<Class<?>> annotatedClasses = Collections.synchronizedSet(new HashSet());
    private static final Queue<RequestHandler> handlers = new ConcurrentLinkedQueue<RequestHandler>();
    private final Map<Class<?>, Object> rpcTargets = new ConcurrentHashMap();
    private final EventHandler<RequestErrorInfo> errorHandler = new ConcurrentEventHandler();

    public EventHandler<RequestErrorInfo> getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized void generateJRPCApiFile() {
        if (cachedSource.get() != null) {
            throw new IllegalStateException("Generated already");
        }
        try {
            JSCodeGenerator generator = new JSCodeGenerator(annotatedClasses);
            cachedSource.set(generator.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addAnnotatedClass(Class<?> cls) {
        annotatedClasses.add(cls);
    }

    public void addRequestHandler(RequestHandler handler) {
        handlers.add(handler);
    }

    public <T> void addTargetInstance(Class<T> targetClass, T instance) {
        this.rpcTargets.put(targetClass, instance);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleRequest(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleRequest(req, resp);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        if (uri.endsWith("/rpc")) {
            this.handleJRPCRequest(request, response);
        } else if (uri.endsWith("/rpc-api.js")) {
            this.handleJSResource(request, response);
        } else {
            response.setStatus(404);
        }
    }

    private void handleJSResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (cachedSource.get() == null) {
            response.setStatus(425);
        } else {
            response.setStatus(200);
            response.setContentType("text/javascript");
            try (PrintWriter writer = response.getWriter();){
                writer.write(cachedSource.get());
            }
        }
    }

    private void setErrorResponse(int code, int id, String message, HttpServletResponse response) throws IOException {
        JSONObject data = new JSONObject();
        data.put("jsonrpc", (Object)"2.0");
        data.put("id", id);
        JSONObject error = new JSONObject();
        error.put("code", code);
        error.put("message", (Object)message);
        data.put("error", (Object)error);
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(code);
        try (PrintWriter writer = response.getWriter();){
            writer.print(data);
        }
    }

    private void setResponse(int id, Object result, HttpServletResponse response) throws IOException {
        JSONObject data = new JSONObject();
        data.put("jsonrpc", (Object)"2.0");
        data.put("id", id);
        if (result != null) {
            if (result.getClass().isAnnotationPresent(JSONSerializable.class)) {
                data.put("result", (Object)JSONUtility.serializeStructure((Object)result));
            } else {
                data.put("result", result);
            }
        }
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();){
            writer.print(data);
        }
    }

    private Method getMethodBySignature(Class<?> cls, String name) throws NoSuchMethodException {
        Method[] publicMethods;
        for (Method method : publicMethods = cls.getMethods()) {
            if (!method.getName().equals(name) || !method.isAnnotationPresent(JRPCMethod.class)) continue;
            return method;
        }
        throw new NoSuchMethodException("There is no method " + cls.getName() + "::" + name);
    }

    private Object invokeMethod(Class<?> cls, Method method, JRPCMethod meta, int requestId, JSONObject params, CallContext context) throws BadRequestException, InvocationTargetException, IllegalAccessException {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        DefaultPropertySerializer defaultSerializer = new DefaultPropertySerializer();
        block10: for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Annotation annotation = ReflectionUtils.getParameterAnnotation(parameter);
            if (annotation == null) {
                throw new RuntimeException("Argument annotation not found in method " + cls.getName() + "::" + method.getName());
            }
            if (annotation instanceof JRPCContext) {
                arguments[i] = context;
                continue;
            }
            if (!(annotation instanceof JRPCArgument)) continue;
            JRPCArgument argument = (JRPCArgument)annotation;
            Object serializedValue = params.get(argument.name());
            switch (argument.dataType()) {
                case Plain: {
                    arguments[i] = defaultSerializer.deserialize(serializedValue, argument.type()[0].equals(Void.class) ? parameter.getType() : argument.type()[0]);
                    continue block10;
                }
                case Collection: {
                    arguments[i] = JSONUtility.deserializeCollection((JSONArray)((JSONArray)serializedValue), argument.type()[0], argument.serializer()[0]);
                    continue block10;
                }
                case Map: {
                    arguments[i] = JSONUtility.deserializeMap((JSONObject)((JSONObject)serializedValue), argument.type()[0], argument.type()[1], argument.serializer()[0], argument.serializer()[1]);
                }
            }
        }
        Object result = null;
        if (isStatic) {
            result = method.invoke(null, arguments);
        } else {
            if (!this.rpcTargets.containsKey(cls)) {
                throw new BadRequestException(requestId, "The method was found, but there is no " + cls.getSimpleName() + " instance to call the method.");
            }
            Object instance = this.rpcTargets.get(cls);
            result = method.invoke(instance, arguments);
        }
        switch (meta.dataType()) {
            case Plain: {
                JSONSerializer serializer = JSONUtility.instantiateSerializer(meta.serializer()[0]);
                return serializer.serialize(result);
            }
            case Collection: {
                return JSONUtility.serializeCollection((Collection)((Collection)result), meta.type()[0], meta.serializer()[0]);
            }
            case Map: {
                return JSONUtility.serializeMap((Map)((Map)result), meta.type()[0], meta.type()[1], meta.serializer()[0], meta.serializer()[1]);
            }
        }
        return null;
    }

    private void handleJRPCRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            HttpSession session = request.getSession(true);
            try (ServletInputStream is = request.getInputStream();){
                JSONObject requestData = new JSONObject(new JSONTokener((InputStream)is));
                for (String param : List.of("method", "params", "id")) {
                    if (requestData.has(param)) continue;
                    throw new BadRequestException(-1, "Invalid request format. Field " + param + " is required!");
                }
                String[] methodName = requestData.getString("method").split(Pattern.quote("::"));
                JSONObject params = requestData.getJSONObject("params");
                int id = requestData.getInt("id");
                if (methodName.length != 2) {
                    throw new BadRequestException(id, "Invalid method name format");
                }
                try {
                    Class<?> foundClass = Class.forName(methodName[0]);
                    Method method = this.getMethodBySignature(foundClass, methodName[1]);
                    JRPCMethod meta = method.getAnnotation(JRPCMethod.class);
                    if (meta == null) {
                        throw new SecurityException("Unable to execute method " + method.getName() + ". Forbidden.");
                    }
                    CallContext context = new CallContext(session, request);
                    for (RequestHandler handler : handlers) {
                        handler.handleRequest(request, response, new MethodCall(foundClass, method, params, context));
                    }
                    this.setResponse(id, this.invokeMethod(foundClass, method, meta, id, params, context), response);
                }
                catch (ClassNotFoundException | NoSuchMethodException nfe) {
                    this.setErrorResponse(404, id, nfe.getMessage(), response);
                    this.errorHandler.invoke((Object)new RequestErrorInfo(requestData, request, nfe));
                }
                catch (SecurityException se) {
                    this.setErrorResponse(403, id, se.getMessage(), response);
                    this.errorHandler.invoke((Object)new RequestErrorInfo(requestData, request, se));
                }
            }
            catch (BadRequestException bre) {
                this.setErrorResponse(400, bre.getRequestId(), bre.getMessage(), response);
                this.errorHandler.invoke((Object)new RequestErrorInfo(null, request, (Throwable)((Object)bre)));
            }
        }
        catch (Exception ioe) {
            this.setErrorResponse(500, -1, ioe.getMessage(), response);
            try {
                this.errorHandler.invoke((Object)new RequestErrorInfo(null, request, ioe));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class BadRequestException
    extends ServletException {
        private final int requestId;

        public BadRequestException(int id, String message) {
            super(message);
            this.requestId = id;
        }

        public int getRequestId() {
            return this.requestId;
        }
    }

    public static final class RequestErrorInfo {
        private final JSONObject requestData;
        private final HttpServletRequest request;
        private final Throwable error;

        public RequestErrorInfo(JSONObject requestData, HttpServletRequest request, Throwable error) {
            this.requestData = requestData;
            this.request = request;
            this.error = error;
        }

        public JSONObject getRequestData() {
            return this.requestData;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

