/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.rpc.CodeGeneration;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import ru.kirillius.json.rpc.Annotations.JRPCArgument;
import ru.kirillius.json.rpc.Annotations.JRPCContext;
import ru.kirillius.json.rpc.Annotations.JRPCMethod;
import ru.kirillius.json.rpc.ReflectionUtils;

public class JSCodeGenerator {
    private final StringBuilder builder = new StringBuilder();
    private final List<Class<?>> enums = new ArrayList();

    public JSCodeGenerator(Collection<Class<?>> classes) throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("json-rpc-sources/jrpc-template.js");){
            assert (is != null);
            while (is.available() > 0) {
                this.builder.append((char)is.read());
            }
        }
        this.builder.append("\r\n");
        for (Class<?> cls : classes) {
            if (cls.isEnum()) {
                this.enums.add(cls);
                continue;
            }
            String cn = cls.getSimpleName();
            boolean init = false;
            for (Method method : cls.getMethods()) {
                JRPCMethod meta = method.getAnnotation(JRPCMethod.class);
                if (meta == null) continue;
                if (!init) {
                    init = true;
                    this.builder.append("JSONRPC.").append(cn).append(" = {};\r\n");
                }
                this.builder.append("\r\nJSONRPC.").append(cn).append('.').append(method.getName()).append('=').append((CharSequence)this.generateAsyncFunction(method)).append(";\r\n");
            }
        }
        for (Class<?> anEnum : this.enums) {
            this.builder.append("\r\n").append((CharSequence)this.generateEnum(anEnum));
        }
    }

    public String toString() {
        return this.builder.toString();
    }

    private StringBuilder generateEnum(Class<?> cls) {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPES.").append(cls.getSimpleName()).append("={");
        StringJoiner joiner = new StringJoiner(", \r\n");
        for (Enum value : this.getEnumValues(cls)) {
            String name = value.name();
            joiner.add("\"" + name + "\":\"" + name + "\"");
        }
        sb.append(joiner).append("};");
        return sb;
    }

    private <T extends Enum<?>> List<T> getEnumValues(Class<?> aCls) {
        try {
            Method method = aCls.getMethod("values", new Class[0]);
            Enum[] result = (Enum[])method.invoke(null, new Object[0]);
            return Arrays.asList(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder generateAsyncFunction(Method method) {
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (!parameterType.isEnum() || this.enums.contains(parameterType)) continue;
            this.enums.add(parameterType);
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isEnum() && !this.enums.contains(returnType)) {
            this.enums.add(returnType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("async function(");
        StringJoiner sj = new StringJoiner(", ");
        List<String> parameterNames = Arrays.stream(method.getParameters()).filter(parameter -> !parameter.isAnnotationPresent(JRPCContext.class)).map(parameter -> {
            Annotation annotation = ReflectionUtils.getParameterAnnotation(parameter);
            if (annotation instanceof JRPCArgument) {
                JRPCArgument argument = (JRPCArgument)annotation;
                return argument.name();
            }
            throw new RuntimeException("There is an argument in JRPC method " + method.getName() + " without argument annotations");
        }).toList();
        for (String parameter2 : parameterNames) {
            sj.add(parameter2);
        }
        sb.append(sj).append("){\r\n");
        sb.append("\treturn await JSONRPC.__invoke(\"").append(method.getDeclaringClass().getName()).append("::").append(method.getName()).append("\"");
        sb.append(", {");
        sj = new StringJoiner(", ");
        for (String parameter2 : parameterNames) {
            sj.add("\"" + parameter2 + "\":" + parameter2);
        }
        sb.append(sj);
        sb.append("});\r\n}");
        return sb;
    }
}

