/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.rpc.CodeGeneration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ru.kirillius.json.rpc.CodeGeneration.JSCodeGenerator;

public class AutoGenerationUtility {
    public static void main(String[] args) throws IOException {
        File root = new File(".");
        File classesRoot = new File(root, "target/classes");
        File output = args.length == 0 ? new File(root, "target/generated-sources/rpc-api.js") : new File(args[0]);
        ArrayList classes = new ArrayList();
        for (String cname : AutoGenerationUtility.findClassesRecursively(classesRoot, classesRoot)) {
            if (cname.contains("$")) continue;
            try {
                classes.add(Class.forName(cname));
            }
            catch (Exception e) {
                System.err.println("Unable to load class " + cname);
            }
        }
        if (!classes.isEmpty()) {
            JSCodeGenerator generator = new JSCodeGenerator(classes);
            try (FileWriter writer = new FileWriter(output);){
                writer.write(generator.toString());
            }
        }
    }

    private static List<String> findClassesRecursively(File dir, File root) {
        ArrayList<String> list = new ArrayList<String>();
        String prefix = dir.getAbsolutePath().replace(root.getAbsolutePath(), "").replaceAll(Pattern.quote("\\"), ".").replaceAll(Pattern.quote("/"), ".");
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    list.addAll(AutoGenerationUtility.findClassesRecursively(file, root));
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".class")) continue;
                Object name = prefix + "." + file.getName().replace(".class", "");
                if (((String)name).startsWith(".")) {
                    name = ((String)name).substring(1);
                }
                list.add((String)name);
            }
        }
        return list;
    }
}

