export const JSONRPC = {
    url: "/jsonrpc/rpc",
    __id: 1,
    /**
     *
     * @param method
     * @param params
     * @param callback
     * @returns {success: function}
     * @private
     */
    __invoke: async function (method, params, callback) {
        const request = await this.__performRequest(method, params);
        if (callback) {
            callback(request.result, request.success);
        }
    },
    __performRequest: async function (method, params) {
        const __this = this;
        const resp = await fetch(
            __this.url,
            {
                method: "POST",
                mode: "cors",
                cache: "no-cache",
                credentials: "include",
                headers: {
                    "Content-Type": "application/json"
                },
                redirect: "follow",
                referrerPolicy: "no-referrer",
                body: JSON.stringify({
                    jsonrpc: '2.0',
                    method: method,
                    params: params,
                    id: __this.__id++
                })
            }
        );
        const success = resp.status === 200;
        const result = (success ? (await resp.json()).result : {
            "error": true,
            "code": resp.status,
            "status": resp.statusText,
            "body": await resp.text()
        });

        return {
            "result": result,
            "success": success
        };
    }
};

export const AsyncJSONRPC = {
    __invoke: async function (method, params) {
        const request = await JSONRPC.__performRequest(method, params);

        if (!request.success) {
            console.error(request.result);
            throw new Error("Failed to invoke method " + method + " with params " + JSON.stringify(params));
        }

        return request.result;
    }
};

export const TYPES = {};