/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.rpc.CodeGeneration;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.StringJoiner;
import ru.kirillius.json.rpc.Annotations.JRPCMethod;

public class JSCodeGenerator {
    private final StringBuilder builder = new StringBuilder();

    public JSCodeGenerator(Collection<Class<?>> classes) throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("json-rpc-sources/jrpc-template.js");){
            while (is.available() > 0) {
                this.builder.append((char)is.read());
            }
        }
        this.builder.append("\r\n");
        for (Class<?> cls : classes) {
            String cn = cls.getSimpleName();
            boolean init = false;
            for (Method method : cls.getMethods()) {
                JRPCMethod meta = method.getAnnotation(JRPCMethod.class);
                if (meta == null) continue;
                if (!init) {
                    init = true;
                    this.builder.append("JSONRPC.").append(cn).append(" = {};\r\n");
                }
                this.builder.append("\r\nJSONRPC.").append(cn).append('.').append(method.getName()).append('=').append((CharSequence)JSCodeGenerator.generateFunction(method, meta)).append(";\r\n");
            }
        }
        this.builder.append("\r\nexport default JSONRPC;");
    }

    public String toString() {
        return this.builder.toString();
    }

    private static StringBuilder generateFunction(Method rm, JRPCMethod meta) {
        StringBuilder sb = new StringBuilder();
        sb.append("function(");
        StringJoiner sj = new StringJoiner(", ");
        for (String parameter : meta.description()) {
            sj.add(parameter);
        }
        sj.add("callback");
        sb.append(sj).append("){\r\n");
        sb.append("\treturn JSONRPC.__invoke(\"").append(rm.getDeclaringClass().getName()).append("::").append(rm.getName()).append("\"");
        sb.append(", {");
        sj = new StringJoiner(", ");
        for (String parameter : meta.description()) {
            sj.add("\"" + parameter + "\":" + parameter);
        }
        sb.append(sj);
        sb.append("}, callback);\r\n}");
        return sb;
    }
}

