JSONRPC = {
    url: "/jsonrpc/rpc",
    __id: 1,
    /**
     *
     * @param method
     * @param params
     * @param callback
     * @returns {success: function}
     * @private
     */
    __invoke: function (method, params, callback) {
        var __this = this;
        return $.ajax({
            url: __this.url,
            data: JSON.stringify({
                jsonrpc: '2.0',
                method: method,
                params: params,
                id: this.__id++
            }),
            type: "POST",
            dataType: "json",
            contentType: 'application/json',
            success: function (result) {
                if (callback !== undefined) {
                    callback(result.result);
                }
            },
            error: function (err) {
                console.error({
                    "error": err,
                    "method": method,
                    "params": params
                });
            }
        });
    }
};