/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.DefaultPropertySerializer;
import ru.kirillius.json.JSONSerializable;
import ru.kirillius.json.JSONSerializer;
import ru.kirillius.json.SerializationException;

public class JSONUtility {
    private static final Map<Class<? extends JSONSerializer<?>>, JSONSerializer<?>> serializers = new ConcurrentHashMap();
    private static final List<Class<?>> builtinTypes = List.of(Short.TYPE, Short.class, Integer.TYPE, Integer.class, BigInteger.class, BigDecimal.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Long.TYPE, Long.class, Boolean.TYPE, Boolean.class, String.class);
    private static final List<Class<?>> builtinIntegerTypes = List.of(Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class);
    private static final List<Class<?>> builtinDecimalTypes = List.of(Float.TYPE, Float.class, Double.TYPE, Double.class);

    public static JSONObject serializeStructure(Object source) throws SerializationException {
        Class<Object> clazz;
        if (source == null) {
            return null;
        }
        if (source instanceof JSONObject) {
            return (JSONObject)source;
        }
        if (source instanceof Annotation) {
            Annotation annotation = (Annotation)source;
            clazz = annotation.annotationType();
        } else {
            clazz = source.getClass();
        }
        Class<?> type = clazz;
        Class serializerType = JSONUtility.getSerializer(type);
        Object instance = JSONUtility.instantiateSerializer(serializerType);
        return (JSONObject)instance.serialize((Object)source);
    }

    public static <T> T deserializeStructure(JSONObject source, Class<T> type) throws SerializationException {
        if (source == null) {
            return null;
        }
        if (type.equals(JSONObject.class)) {
            return (T)source;
        }
        Class serializerType = JSONUtility.getSerializer(type);
        Object instance = JSONUtility.instantiateSerializer(serializerType);
        return instance.deserialize(source, type);
    }

    private static <T, S extends JSONSerializer<T>> Class<S> getSerializer(Class<T> type) throws SerializationException {
        JSONSerializable serializerType = type.getAnnotation(JSONSerializable.class);
        if (serializerType == null) {
            throw new SerializationException("Unable to serialize class " + type.getName() + " because @" + JSONSerializable.class.getName() + " is not present");
        }
        return serializerType.value();
    }

    public static <S extends JSONSerializer<?>> S instantiateSerializer(Class<S> type) {
        Map<Class<? extends JSONSerializer<?>>, JSONSerializer<?>> map = serializers;
        synchronized (map) {
            if (serializers.containsKey(type)) {
                return (S)serializers.get(type);
            }
            try {
                JSONSerializer instance = (JSONSerializer)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                serializers.put(type, instance);
                return (S)instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, S extends JSONSerializer<T>> void addSerializer(Class<S> type, JSONSerializer<T> serializer) {
        Map<Class<? extends JSONSerializer<?>>, JSONSerializer<?>> map = serializers;
        synchronized (map) {
            serializers.put(type, serializer);
        }
    }

    public static <T> JSONArray serializeCollection(Collection<T> collection, Class<T> type, @Nullable Class<? extends JSONSerializer<T>> serializer) throws SerializationException {
        JSONArray array = new JSONArray();
        if (collection == null) {
            return array;
        }
        if (serializer == null) {
            serializer = JSONUtility.isBuiltinOrPrimitive(type) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(type);
        }
        JSONSerializer<T> instance = JSONUtility.instantiateSerializer(serializer);
        for (T item : collection) {
            array.put(instance.serialize(item));
        }
        return array;
    }

    public static <T> Stream<T> deserializeCollection(JSONArray array, Class<T> type, @Nullable Class<? extends JSONSerializer<T>> serializer) throws SerializationException {
        if (array == null) {
            return null;
        }
        if (serializer == null) {
            serializer = JSONUtility.isBuiltinOrPrimitive(type) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(type);
        }
        JSONSerializer instance = JSONUtility.instantiateSerializer(serializer);
        return StreamSupport.stream(array.spliterator(), false).map(o -> instance.deserialize(o, type));
    }

    public static <K, V> JSONObject serializeMap(Map<K, V> map, Class<K> keyType, Class<V> valueType, @Nullable Class<? extends JSONSerializer<K>> keySerializer, @Nullable Class<? extends JSONSerializer<V>> valueSerializer) throws SerializationException {
        JSONObject object = new JSONObject();
        if (map == null) {
            return object;
        }
        if (keySerializer == null) {
            keySerializer = JSONUtility.isBuiltinOrPrimitive(keyType) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(keyType);
        }
        JSONSerializer<K> keySerializerInstance = JSONUtility.instantiateSerializer(keySerializer);
        if (valueSerializer == null) {
            valueSerializer = JSONUtility.isBuiltinOrPrimitive(valueType) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(valueType);
        }
        JSONSerializer<V> valueSerializerInstance = JSONUtility.instantiateSerializer(valueSerializer);
        for (K key : map.keySet()) {
            String keyName = keySerializerInstance.serialize(key).toString();
            object.put(keyName, valueSerializerInstance.serialize(map.get(key)));
        }
        return object;
    }

    public static <K, V> Map<K, V> deserializeMap(JSONObject object, Class<K> keyType, Class<V> valueType, @Nullable Class<? extends JSONSerializer<K>> keySerializer, @Nullable Class<? extends JSONSerializer<V>> valueSerializer) throws SerializationException {
        HashMap<K, V> map = new HashMap<K, V>();
        if (object == null) {
            return null;
        }
        if (keySerializer == null) {
            keySerializer = JSONUtility.isBuiltinOrPrimitive(keyType) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(keyType);
        }
        JSONSerializer<K> keySerializerInstance = JSONUtility.instantiateSerializer(keySerializer);
        if (valueSerializer == null) {
            valueSerializer = JSONUtility.isBuiltinOrPrimitive(keyType) ? DefaultPropertySerializer.class : JSONUtility.getSerializer(valueType);
        }
        JSONSerializer<V> valueSerializerInstance = JSONUtility.instantiateSerializer(valueSerializer);
        for (String keyName : object.keySet()) {
            K key = keySerializerInstance.deserialize(keyName, keyType);
            map.put(key, valueSerializerInstance.deserialize(object.get(keyName), valueType));
        }
        return map;
    }

    static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(JSONUtility.getAllFields(type.getSuperclass()));
        }
        return fields;
    }

    public static boolean isBuiltinOrPrimitive(Class<?> type) {
        return builtinTypes.contains(type);
    }

    static boolean isPrimitiveInteger(Class<?> type) {
        return builtinIntegerTypes.contains(type);
    }

    static boolean isPrimitiveDecimal(Class<?> type) {
        return builtinDecimalTypes.contains(type);
    }

    static boolean isPrimitiveNumber(Class<?> type) {
        return JSONUtility.isPrimitiveDecimal(type) || JSONUtility.isPrimitiveInteger(type);
    }

    private JSONUtility() {
        throw new IllegalStateException();
    }
}

