/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.TypeDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.JSONSerializer;
import ru.kirillius.json.JSONUtility;
import ru.kirillius.json.SerializationException;

public class DefaultPropertySerializer
implements JSONSerializer<Object> {
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    @Override
    public Object serialize(Object source) throws SerializationException {
        if (source == null) {
            return null;
        }
        if (source.getClass().isArray()) {
            return this.serializeArray(source);
        }
        if (source instanceof File) {
            File file = (File)source;
            return file.getPath();
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            return format.format(date);
        }
        if (source instanceof JSONArray || source instanceof JSONObject) {
            return source;
        }
        if (source instanceof Enum || source instanceof String) {
            return source.toString();
        }
        if (source instanceof Class) {
            Class aClass = (Class)source;
            return aClass.getName();
        }
        Class<?> type = source.getClass();
        if (JSONUtility.isBuiltinOrPrimitive(type)) {
            return source;
        }
        return JSONUtility.serializeStructure(source);
    }

    private Object serializeArray(Object source) {
        JSONArray array;
        block16: {
            block26: {
                String[] strings;
                block25: {
                    JSONArray[] jsonObjectArray;
                    block24: {
                        JSONObject[] jsonObjectArray2;
                        block23: {
                            boolean[] booleanArray;
                            block22: {
                                char[] cArray;
                                block21: {
                                    double[] dArray;
                                    block20: {
                                        float[] fArray;
                                        block19: {
                                            long[] longArray;
                                            block18: {
                                                int[] intArray;
                                                block17: {
                                                    short[] shortArray;
                                                    block15: {
                                                        byte[] byteArray;
                                                        array = new JSONArray();
                                                        if (!(source instanceof byte[])) break block15;
                                                        for (byte b : byteArray = (byte[])source) {
                                                            array.put((int)b);
                                                        }
                                                        break block16;
                                                    }
                                                    if (!(source instanceof short[])) break block17;
                                                    for (short b : shortArray = (short[])source) {
                                                        array.put((int)b);
                                                    }
                                                    break block16;
                                                }
                                                if (!(source instanceof int[])) break block18;
                                                for (int b : intArray = (int[])source) {
                                                    array.put(b);
                                                }
                                                break block16;
                                            }
                                            if (!(source instanceof long[])) break block19;
                                            for (long b : longArray = (long[])source) {
                                                array.put(b);
                                            }
                                            break block16;
                                        }
                                        if (!(source instanceof float[])) break block20;
                                        for (float b : fArray = (float[])source) {
                                            array.put(b);
                                        }
                                        break block16;
                                    }
                                    if (!(source instanceof double[])) break block21;
                                    for (double b : dArray = (double[])source) {
                                        array.put(b);
                                    }
                                    break block16;
                                }
                                if (!(source instanceof char[])) break block22;
                                for (char b : cArray = (char[])source) {
                                    array.put((int)b);
                                }
                                break block16;
                            }
                            if (!(source instanceof boolean[])) break block23;
                            for (boolean b : booleanArray = (boolean[])source) {
                                array.put(b);
                            }
                            break block16;
                        }
                        if (!(source instanceof JSONObject[])) break block24;
                        for (JSONObject b : jsonObjectArray2 = (JSONObject[])source) {
                            array.put((Object)b);
                        }
                        break block16;
                    }
                    if (!(source instanceof JSONArray[])) break block25;
                    for (JSONArray b : jsonObjectArray = (JSONArray[])source) {
                        array.put((Object)b);
                    }
                    break block16;
                }
                if (!(source instanceof String[])) break block26;
                for (String b : strings = (String[])source) {
                    array.put((Object)b);
                }
                break block16;
            }
            if (!(source instanceof Object[])) break block16;
            Object[] objectArray = (Object[])source;
            TypeDescriptor.OfField arrayType = source.getClass().arrayType();
            if (JSONUtility.isBuiltinOrPrimitive(arrayType)) {
                for (Object b : objectArray) {
                    array.put(b);
                }
            }
            if (Annotation.class.isAssignableFrom((Class<?>)arrayType)) {
                for (Object b : objectArray) {
                    array.put((Object)JSONUtility.serializeStructure(b));
                }
            }
        }
        return array;
    }

    private <T> T castPrimitiveNumber(Object source, Class<T> target) {
        if (target.equals(Short.class) || target.equals(Short.TYPE)) {
            short value = 0;
            if (source instanceof Short) {
                value = (Short)source;
            } else if (source instanceof Integer) {
                value = (short)((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = (short)((Long)source).longValue();
            } else if (source instanceof Float) {
                value = (short)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (short)((Double)source).doubleValue();
            }
            return (T)Short.valueOf(value);
        }
        if (target.equals(Integer.class) || target.equals(Integer.TYPE)) {
            int value = 0;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = (Integer)source;
            } else if (source instanceof Long) {
                value = (int)((Long)source).longValue();
            } else if (source instanceof Float) {
                value = (int)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (int)((Double)source).doubleValue();
            }
            return (T)Integer.valueOf(value);
        }
        if (target.equals(Long.class) || target.equals(Long.TYPE)) {
            long value = 0L;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = (Long)source;
            } else if (source instanceof Float) {
                value = (long)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (long)((Double)source).doubleValue();
            }
            return (T)Long.valueOf(value);
        }
        if (target.equals(Float.class) || target.equals(Float.TYPE)) {
            float value = 0.0f;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = ((Long)source).longValue();
            } else if (source instanceof Float) {
                value = ((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (float)((Double)source).doubleValue();
            }
            return (T)Float.valueOf(value);
        }
        if (target.equals(Double.class) || target.equals(Double.TYPE)) {
            double value = 0.0;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = ((Long)source).longValue();
            } else if (source instanceof Float) {
                value = ((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (Double)source;
            }
            return (T)Double.valueOf(value);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object deserialize(Object source, Class<?> targetType) throws SerializationException {
        if (Object.class.equals(targetType)) {
            return source;
        }
        if (Date.class.isAssignableFrom(targetType)) {
            try {
                return format.parse(source.toString());
            }
            catch (ParseException e) {
                throw new SerializationException(e);
            }
        }
        if (File.class.equals(targetType)) {
            return new File(source.toString());
        }
        if (targetType.isEnum()) {
            return Enum.valueOf(targetType, source.toString());
        }
        if (Class.class.isAssignableFrom(targetType)) {
            try {
                return this.getClass().getClassLoader().loadClass(source.toString());
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException(e);
            }
        }
        if (JSONArray.class.equals(targetType) || JSONObject.class.equals(targetType)) {
            return source;
        }
        if (JSONUtility.isBuiltinOrPrimitive(targetType)) {
            if (targetType.equals(source.getClass())) {
                return source;
            }
            if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
                return Boolean.valueOf(source.toString());
            }
            if (JSONUtility.isPrimitiveNumber(targetType) && JSONUtility.isPrimitiveNumber(source.getClass())) {
                return this.castPrimitiveNumber(source, targetType);
            }
            if (JSONUtility.isPrimitiveInteger(targetType)) {
                return this.castPrimitiveNumber(Long.valueOf(source.toString()), targetType);
            }
            if (JSONUtility.isPrimitiveDecimal(targetType)) {
                return this.castPrimitiveNumber(Double.valueOf(source.toString()), targetType);
            }
            if (targetType.equals(BigInteger.class)) {
                if (JSONUtility.isPrimitiveInteger(source.getClass())) {
                    return BigInteger.valueOf((Long)source);
                }
                return new BigInteger(source.toString());
            }
            if (targetType.equals(BigDecimal.class)) {
                if (JSONUtility.isPrimitiveNumber(source.getClass())) {
                    return BigDecimal.valueOf((Double)source);
                }
                return new BigDecimal(source.toString());
            }
        }
        if (source instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)source;
            return JSONUtility.deserializeStructure(jsonObject, targetType);
        }
        if (targetType.equals(Object.class)) {
            return source;
        }
        throw new SerializationException("Unable to find a way how to deserialize " + String.valueOf(source.getClass()) + " as " + String.valueOf(targetType));
    }

    static {
        format.setTimeZone(GMT);
    }
}

