/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.JSONArrayProperty;
import ru.kirillius.json.JSONMapProperty;
import ru.kirillius.json.JSONProperty;
import ru.kirillius.json.JSONSerializer;
import ru.kirillius.json.JSONUtility;
import ru.kirillius.json.SerializationException;

public class DefaultObjectSerializer
implements JSONSerializer<Object> {
    @Override
    public Object serialize(Object source) throws SerializationException {
        List<Field> fields = JSONUtility.getAllFields(source.getClass());
        JSONObject json = new JSONObject();
        for (Field field : fields) {
            Annotation annotation = this.getAnnotation(field);
            if (annotation == null) continue;
            field.setAccessible(true);
            if (annotation instanceof JSONProperty) {
                JSONProperty jsonProperty = (JSONProperty)annotation;
                JSONSerializer serializer = JSONUtility.instantiateSerializer(jsonProperty.value());
                try {
                    json.put(field.getName(), serializer.serialize(field.get(source)));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(e);
                }
            }
            if (annotation instanceof JSONArrayProperty) {
                JSONArrayProperty jsonArrayProperty = (JSONArrayProperty)annotation;
                try {
                    json.put(field.getName(), (Object)JSONUtility.serializeCollection((Collection)field.get(source), jsonArrayProperty.type(), jsonArrayProperty.serializer()));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(e);
                }
            }
            if (!(annotation instanceof JSONMapProperty)) continue;
            JSONMapProperty jsonMapProperty = (JSONMapProperty)annotation;
            try {
                json.put(field.getName(), (Object)JSONUtility.serializeMap((Map)field.get(source), jsonMapProperty.keyType(), jsonMapProperty.valueType(), jsonMapProperty.keySerializer(), jsonMapProperty.valueSerializer()));
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
        }
        return json;
    }

    private Annotation getAnnotation(Field field) {
        for (Class<JSONMapProperty> aClass : List.of(JSONProperty.class, JSONArrayProperty.class, JSONMapProperty.class)) {
            if (!field.isAnnotationPresent(aClass)) continue;
            return field.getAnnotation(aClass);
        }
        return null;
    }

    private boolean isPropertyRequired(Annotation annotation) {
        if (annotation instanceof JSONProperty) {
            JSONProperty jsonProperty = (JSONProperty)annotation;
            return jsonProperty.required();
        }
        if (annotation instanceof JSONArrayProperty) {
            JSONArrayProperty jsonArrayProperty = (JSONArrayProperty)annotation;
            return jsonArrayProperty.required();
        }
        if (annotation instanceof JSONMapProperty) {
            JSONMapProperty jsonMapProperty = (JSONMapProperty)annotation;
            return jsonMapProperty.required();
        }
        throw new IllegalArgumentException("Unsupported annotation: " + String.valueOf(annotation));
    }

    @Override
    public Object deserialize(Object source, Class<?> type) throws SerializationException {
        try {
            Object instance = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            List<Field> fields = JSONUtility.getAllFields(type);
            JSONObject json = (JSONObject)source;
            for (Field field : fields) {
                String fieldName;
                Annotation annotation = this.getAnnotation(field);
                if (annotation == null || !json.has(fieldName = field.getName()) && !this.isPropertyRequired(annotation)) continue;
                field.setAccessible(true);
                Object value = json.get(fieldName);
                if (annotation instanceof JSONProperty) {
                    JSONProperty jsonProperty = (JSONProperty)annotation;
                    JSONSerializer serializer = JSONUtility.instantiateSerializer(jsonProperty.value());
                    field.set(instance, serializer.deserialize(value, field.getType()));
                    continue;
                }
                if (annotation instanceof JSONArrayProperty) {
                    JSONArrayProperty jsonArrayProperty = (JSONArrayProperty)annotation;
                    Stream<?> stream = JSONUtility.deserializeCollection((JSONArray)value, jsonArrayProperty.type(), jsonArrayProperty.serializer());
                    Collection collection = null;
                    if (jsonArrayProperty.unmodifable()) {
                        switch (jsonArrayProperty.collectionType()) {
                            case List: {
                                collection = stream.collect(Collectors.toUnmodifiableList());
                                break;
                            }
                            case Set: {
                                collection = stream.collect(Collectors.toUnmodifiableSet());
                            }
                        }
                    } else {
                        switch (jsonArrayProperty.collectionType()) {
                            case Set: {
                                collection = stream.collect(Collectors.toSet());
                                break;
                            }
                            case List: {
                                collection = stream.collect(Collectors.toList());
                            }
                        }
                    }
                    field.set(instance, collection);
                    continue;
                }
                if (!(annotation instanceof JSONMapProperty)) continue;
                JSONMapProperty jsonMapProperty = (JSONMapProperty)annotation;
                Map<?, ?> map = JSONUtility.deserializeMap((JSONObject)value, jsonMapProperty.keyType(), jsonMapProperty.valueType(), jsonMapProperty.keySerializer(), jsonMapProperty.valueSerializer());
                field.set(instance, map);
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }
}

