/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.JSONSerializer;
import ru.kirillius.json.JSONUtility;
import ru.kirillius.json.SerializationException;

public class DefaultPropertySerializer
implements JSONSerializer<Object> {
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    @Override
    public Object serialize(Object source) throws SerializationException {
        if (source == null) {
            return null;
        }
        if (source instanceof File) {
            File file = (File)source;
            return file.getPath();
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            return format.format(date);
        }
        if (source instanceof JSONArray || source instanceof JSONObject) {
            return source;
        }
        if (source instanceof Enum || source instanceof String) {
            return source.toString();
        }
        if (source instanceof Class) {
            Class aClass = (Class)source;
            return aClass.getName();
        }
        Class<?> type = source.getClass();
        if (JSONUtility.isBuiltinOrPrimitive(type)) {
            return source;
        }
        return JSONUtility.serializeStructure(source);
    }

    private <T> T castPrimitiveNumber(Object source, Class<T> target) {
        if (target.equals(Short.class) || target.equals(Short.TYPE)) {
            short value = 0;
            if (source instanceof Short) {
                value = (Short)source;
            } else if (source instanceof Integer) {
                value = (short)((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = (short)((Long)source).longValue();
            } else if (source instanceof Float) {
                value = (short)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (short)((Double)source).doubleValue();
            }
            return (T)Short.valueOf(value);
        }
        if (target.equals(Integer.class) || target.equals(Integer.TYPE)) {
            int value = 0;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = (Integer)source;
            } else if (source instanceof Long) {
                value = (int)((Long)source).longValue();
            } else if (source instanceof Float) {
                value = (int)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (int)((Double)source).doubleValue();
            }
            return (T)Integer.valueOf(value);
        }
        if (target.equals(Long.class) || target.equals(Long.TYPE)) {
            long value = 0L;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = (Long)source;
            } else if (source instanceof Float) {
                value = (long)((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (long)((Double)source).doubleValue();
            }
            return (T)Long.valueOf(value);
        }
        if (target.equals(Float.class) || target.equals(Float.TYPE)) {
            float value = 0.0f;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = ((Long)source).longValue();
            } else if (source instanceof Float) {
                value = ((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (float)((Double)source).doubleValue();
            }
            return (T)Float.valueOf(value);
        }
        if (target.equals(Double.class) || target.equals(Double.TYPE)) {
            double value = 0.0;
            if (source instanceof Short) {
                value = ((Short)source).shortValue();
            } else if (source instanceof Integer) {
                value = ((Integer)source).intValue();
            } else if (source instanceof Long) {
                value = ((Long)source).longValue();
            } else if (source instanceof Float) {
                value = ((Float)source).floatValue();
            } else if (source instanceof Double) {
                value = (Double)source;
            }
            return (T)Double.valueOf(value);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object deserialize(Object source, Class<?> targetType) throws SerializationException {
        if (Date.class.isAssignableFrom(targetType)) {
            try {
                return format.parse(source.toString());
            }
            catch (ParseException e) {
                throw new SerializationException(e);
            }
        }
        if (File.class.equals(targetType)) {
            return new File(source.toString());
        }
        if (targetType.isEnum()) {
            return Enum.valueOf(targetType, source.toString());
        }
        if (Class.class.isAssignableFrom(targetType)) {
            try {
                return this.getClass().getClassLoader().loadClass(source.toString());
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException(e);
            }
        }
        if (JSONArray.class.equals(targetType) || JSONObject.class.equals(targetType)) {
            return source;
        }
        if (JSONUtility.isBuiltinOrPrimitive(targetType)) {
            if (targetType.equals(source.getClass())) {
                return source;
            }
            if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
                return Boolean.valueOf(source.toString());
            }
            if (JSONUtility.isPrimitiveNumber(targetType) && JSONUtility.isPrimitiveNumber(source.getClass())) {
                return this.castPrimitiveNumber(source, targetType);
            }
            if (JSONUtility.isPrimitiveInteger(targetType)) {
                return this.castPrimitiveNumber(Long.valueOf(source.toString()), targetType);
            }
            if (JSONUtility.isPrimitiveDecimal(targetType)) {
                return this.castPrimitiveNumber(Double.valueOf(source.toString()), targetType);
            }
            if (targetType.equals(BigInteger.class)) {
                if (JSONUtility.isPrimitiveInteger(source.getClass())) {
                    return BigInteger.valueOf((Long)source);
                }
                return new BigInteger(source.toString());
            }
            if (targetType.equals(BigDecimal.class)) {
                if (JSONUtility.isPrimitiveNumber(source.getClass())) {
                    return BigDecimal.valueOf((Double)source);
                }
                return new BigDecimal(source.toString());
            }
        }
        if (source instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)source;
            return JSONUtility.deserializeStructure(jsonObject, targetType);
        }
        if (targetType.equals(Object.class)) {
            return source;
        }
        throw new SerializationException("Unable to find a way how to deserialize " + source.getClass() + " as " + targetType);
    }

    static {
        format.setTimeZone(GMT);
    }
}

