/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.convert;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public interface JSONCustomTypeConverter<T> {
    public T fromJSONMap(JSONObject var1, String var2, Class<?> var3);

    public T fromJSONArray(JSONArray var1, int var2, Class<?> var3);

    public T fromJSONObject(JSONObject var1, Class<?> var2);

    public T fromString(String var1, Class<?> var2);

    default public JSONObject toJSON(T value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> cls = value.getClass();
        fields.addAll(List.of(cls.getFields()));
        fields.addAll(List.of(cls.getDeclaredFields()));
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                json.put(field.getName(), field.get(value));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }
}

