/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.convert;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.convert.JSONCustomTypeConverter;

public class JSONCaster {
    private final Map<Class<?>, JSONCustomTypeConverter<?>> converters = new ConcurrentHashMap();

    public <T> void addConverter(Class<T> type, JSONCustomTypeConverter<T> converter) {
        this.converters.put(type, converter);
    }

    public <T> void putToJSONObject(JSONObject jsonObject, String key, T value) {
        if (value == null) {
            jsonObject.put(key, null);
            return;
        }
        Class<?> targetType = value.getClass();
        if (targetType.equals(Short.class) || targetType.equals(Integer.class) || targetType.equals(Float.class) || targetType.equals(Double.class) || targetType.equals(Long.class) || targetType.equals(Boolean.class) || targetType.equals(String.class) || targetType.equals(JSONObject.class) || targetType.equals(JSONArray.class)) {
            jsonObject.put(key, value);
        } else if (value instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection list = (Collection)value;
            Object[] values = list.toArray();
            for (int i = 0; i < list.size(); ++i) {
                this.putToJSONArray(array, i, values[i]);
            }
            jsonObject.put(key, (Object)array);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonMap = new JSONObject();
            for (Object k : map.keySet()) {
                this.putToJSONObject(jsonMap, k.toString(), map.get(k));
            }
            jsonObject.put(key, (Object)jsonMap);
        } else {
            JSONCustomTypeConverter<?> converter = this.findConverterForType(targetType);
            if (converter != null) {
                jsonObject.put(key, (Object)converter.toJSON(value, targetType));
            } else {
                jsonObject.put(key, value);
            }
        }
    }

    private <T> JSONCustomTypeConverter<T> findConverterForType(Class<T> targetType) {
        if (this.converters.containsKey(targetType)) {
            return this.converters.get(targetType);
        }
        for (Class<T> clazz : this.converters.keySet()) {
            if (!clazz.isAssignableFrom(targetType)) continue;
            JSONCustomTypeConverter<?> converter = this.converters.get(clazz);
            this.converters.put(targetType, converter);
            return converter;
        }
        return null;
    }

    public <T> void putToJSONArray(JSONArray jsonArray, int index, T value) {
        if (value == null) {
            jsonArray.put(index, null);
            return;
        }
        Class<?> targetType = value.getClass();
        if (targetType.equals(Short.class) || targetType.equals(Integer.class) || targetType.equals(Float.class) || targetType.equals(Double.class) || targetType.equals(Long.class) || targetType.equals(Boolean.class) || targetType.equals(String.class) || targetType.equals(JSONObject.class) || targetType.equals(JSONArray.class)) {
            jsonArray.put(index, value);
        } else if (value instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection list = (Collection)value;
            Object[] values = list.toArray();
            for (int i = 0; i < list.size(); ++i) {
                this.putToJSONArray(array, i, values[i]);
            }
            jsonArray.put(index, (Object)array);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonMap = new JSONObject();
            for (Object k : map.keySet()) {
                this.putToJSONObject(jsonMap, k.toString(), map.get(k));
            }
            jsonArray.put(index, (Object)jsonMap);
        } else {
            JSONCustomTypeConverter<?> converter = this.findConverterForType(targetType);
            if (converter != null) {
                jsonArray.put(index, (Object)converter.toJSON(value, targetType));
            } else {
                jsonArray.put(index, value);
            }
        }
    }

    private <T> T enumFromString(String value, Class<T> enumType) {
        try {
            Method method = enumType.getMethod("valueOf", String.class);
            return (T)method.invoke(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Enum casting failed", e);
        }
    }

    public <T> T castValueFromJSONMap(JSONObject jsonObject, String key, Class<T> targetType) {
        if (jsonObject.isNull(key)) {
            return null;
        }
        if (targetType.isEnum()) {
            return this.enumFromString(jsonObject.getString(key), targetType);
        }
        if (targetType.equals(JSONArray.class)) {
            return (T)jsonObject.getJSONArray(key);
        }
        if (targetType.equals(JSONObject.class)) {
            return (T)jsonObject.getJSONObject(key);
        }
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf((short)jsonObject.getInt(key));
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(jsonObject.getInt(key));
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(jsonObject.getFloat(key));
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(jsonObject.getDouble(key));
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(jsonObject.getLong(key));
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(jsonObject.getBoolean(key));
        }
        if (targetType.equals(String.class)) {
            return (T)jsonObject.getString(key);
        }
        if (targetType.equals(Set.class)) {
            Type typeOfList = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)new HashSet<T>(this.castJSONToList(jsonObject.getJSONArray(key), (Class)typeOfList));
        }
        if (targetType.equals(List.class)) {
            Type typeOfList = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)this.castJSONToList(jsonObject.getJSONArray(key), (Class)typeOfList);
        }
        if (targetType.equals(Map.class)) {
            Type[] types = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments();
            return (T)this.castJSONToMap(jsonObject.getJSONObject(key), (Class)types[0], (Class)types[1]);
        }
        JSONCustomTypeConverter<T> converter = this.findConverterForType(targetType);
        if (converter != null) {
            return converter.fromJSONMap(jsonObject, key, targetType);
        }
        throw new ClassCastException("Unable to cast json value to " + targetType);
    }

    private <T> T castValueFromString(String key, Class<T> targetType) {
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf(key);
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(key);
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(key);
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(key);
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(key);
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(key);
        }
        if (targetType.equals(String.class)) {
            return (T)key;
        }
        JSONCustomTypeConverter<T> converter = this.findConverterForType(targetType);
        if (converter != null) {
            return converter.fromString(key, targetType);
        }
        throw new ClassCastException("Unable to cast string value to " + targetType);
    }

    public <T> T castValueFromJSONArray(JSONArray jsonArray, int index, Class<T> targetType) {
        if (jsonArray.isNull(index)) {
            return null;
        }
        if (targetType.isEnum()) {
            return this.enumFromString(jsonArray.getString(index), targetType);
        }
        if (targetType.equals(JSONArray.class)) {
            return (T)jsonArray.getJSONArray(index);
        }
        if (targetType.equals(JSONObject.class)) {
            return (T)jsonArray.getJSONObject(index);
        }
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf((short)jsonArray.getInt(index));
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(jsonArray.getInt(index));
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(jsonArray.getFloat(index));
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(jsonArray.getDouble(index));
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(jsonArray.getLong(index));
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(jsonArray.getBoolean(index));
        }
        if (targetType.equals(String.class)) {
            return (T)jsonArray.getString(index);
        }
        if (targetType.equals(Set.class)) {
            Type typeOfSet = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)new HashSet<T>(this.castJSONToList(jsonArray.getJSONArray(index), (Class)typeOfSet));
        }
        if (targetType.equals(List.class)) {
            Type typeOfList = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)this.castJSONToList(jsonArray.getJSONArray(index), (Class)typeOfList);
        }
        if (targetType.equals(Map.class)) {
            Type[] types = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments();
            return (T)this.castJSONToMap(jsonArray.getJSONObject(index), (Class)types[0], (Class)types[1]);
        }
        JSONCustomTypeConverter<T> converter = this.findConverterForType(targetType);
        if (converter != null) {
            return converter.fromJSONArray(jsonArray, index, targetType);
        }
        throw new ClassCastException("Unable to cast json value to " + targetType);
    }

    public <T> List<T> castJSONToList(JSONArray jsonArray, Class<T> targetType) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(this.castValueFromJSONArray(jsonArray, i, targetType));
        }
        return list;
    }

    public <K, V> Map<K, V> castJSONToMap(JSONObject jsonObject, Class<K> keyType, Class<V> valueType) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (String keyName : jsonObject.keySet()) {
            K key = this.castValueFromString(keyName, keyType);
            V value = this.castValueFromJSONMap(jsonObject, keyName, valueType);
            map.put(key, value);
        }
        return map;
    }

    public <T> T castJSONToObject(JSONObject json, Class<T> targetType) {
        JSONCustomTypeConverter<T> converter = this.findConverterForType(targetType);
        if (converter != null) {
            return converter.fromJSONObject(json, targetType);
        }
        throw new ClassCastException("Failed to cast JSONObject to " + targetType);
    }

    public <T> JSONObject castObjectToJSON(T object, Class<T> targetType) {
        JSONCustomTypeConverter<T> converter = this.findConverterForType(targetType);
        if (converter != null) {
            return converter.toJSON(object, targetType);
        }
        throw new ClassCastException("Failed to cast " + targetType + " to JSONObject");
    }

    public <K, V> JSONObject castMapToJSON(Map<K, V> map) {
        JSONObject json = new JSONObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            this.putToJSONObject(json, key, entry.getValue());
        }
        return json;
    }

    public <T, L extends List<T>> JSONArray castListToJSON(L list) {
        JSONArray json = new JSONArray();
        int i = 0;
        for (T item : list) {
            this.putToJSONArray(json, i++, item);
        }
        return json;
    }
}

