/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.json.convert;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.json.convert.JSONCustomTypeConverter;

public class JSONCaster {
    private final Map<Class<?>, JSONCustomTypeConverter<?>> converters = new ConcurrentHashMap();

    public <T> void addConverter(Class<T> type, JSONCustomTypeConverter<T> converter) {
        this.converters.put(type, converter);
    }

    public <T> void putToJSONObject(JSONObject jsonObject, String key, T value) {
        if (value == null) {
            jsonObject.put(key, null);
            return;
        }
        Class<?> targetType = value.getClass();
        if (targetType.equals(Short.class) || targetType.equals(Integer.class) || targetType.equals(Float.class) || targetType.equals(Double.class) || targetType.equals(Long.class) || targetType.equals(Boolean.class) || targetType.equals(String.class) || targetType.equals(JSONObject.class) || targetType.equals(JSONArray.class)) {
            jsonObject.put(key, value);
        } else if (value instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection list = (Collection)value;
            Object[] values = list.toArray();
            for (int i = 0; i < list.size(); ++i) {
                this.putToJSONArray(array, i, values[i]);
            }
            jsonObject.put(key, (Object)array);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonMap = new JSONObject();
            for (Object k : map.keySet()) {
                this.putToJSONObject(jsonMap, k.toString(), map.get(k));
            }
            jsonObject.put(key, (Object)jsonMap);
        } else if (this.converters.containsKey(targetType)) {
            JSONCustomTypeConverter<?> converter = this.converters.get(targetType);
            jsonObject.put(key, converter.toJSON(value));
        } else {
            jsonObject.put(key, value);
        }
    }

    public <T> void putToJSONArray(JSONArray jsonArray, int index, T value) {
        if (value == null) {
            jsonArray.put(index, null);
            return;
        }
        Class<?> targetType = value.getClass();
        if (targetType.equals(Short.class) || targetType.equals(Integer.class) || targetType.equals(Float.class) || targetType.equals(Double.class) || targetType.equals(Long.class) || targetType.equals(Boolean.class) || targetType.equals(String.class) || targetType.equals(JSONObject.class) || targetType.equals(JSONArray.class)) {
            jsonArray.put(index, value);
        } else if (value instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection list = (Collection)value;
            Object[] values = list.toArray();
            for (int i = 0; i < list.size(); ++i) {
                this.putToJSONArray(array, i, values[i]);
            }
            jsonArray.put(index, (Object)array);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonMap = new JSONObject();
            for (Object k : map.keySet()) {
                this.putToJSONObject(jsonMap, k.toString(), map.get(k));
            }
            jsonArray.put(index, (Object)jsonMap);
        } else if (this.converters.containsKey(targetType)) {
            JSONCustomTypeConverter<?> converter = this.converters.get(targetType);
            jsonArray.put(index, converter.toJSON(value));
        } else {
            jsonArray.put(index, value);
        }
    }

    public <T> T castValueFromJSONObject(JSONObject jsonObject, String key, Class<T> targetType) {
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf((short)jsonObject.getInt(key));
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(jsonObject.getInt(key));
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(jsonObject.getFloat(key));
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(jsonObject.getDouble(key));
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(jsonObject.getLong(key));
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(jsonObject.getBoolean(key));
        }
        if (targetType.equals(String.class)) {
            return (T)jsonObject.getString(key);
        }
        if (targetType.equals(List.class)) {
            Type typeOfList = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)this.castJSONList(jsonObject.getJSONArray(key), (Class)typeOfList);
        }
        if (targetType.equals(Map.class)) {
            Type[] types = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments();
            return (T)this.castJSONMap(jsonObject.getJSONObject(key), (Class)types[0], (Class)types[1]);
        }
        if (this.converters.containsKey(targetType)) {
            JSONCustomTypeConverter<?> converter = this.converters.get(targetType);
            return (T)converter.fromJSONObject(jsonObject, key);
        }
        throw new ClassCastException("Unable to cast json value to " + targetType);
    }

    private <T> T castValueFromString(String key, Class<T> targetType) {
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf(key);
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(key);
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(key);
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(key);
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(key);
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(key);
        }
        if (targetType.equals(String.class)) {
            return (T)key;
        }
        if (this.converters.containsKey(targetType)) {
            JSONCustomTypeConverter<?> converter = this.converters.get(targetType);
            return (T)converter.fromString(key);
        }
        throw new ClassCastException("Unable to cast string value to " + targetType);
    }

    public <T> T castValueFromJSONArray(JSONArray jsonArray, int index, Class<T> targetType) {
        if (targetType.equals(Short.TYPE) || targetType.equals(Short.class)) {
            return (T)Short.valueOf((short)jsonArray.getInt(index));
        }
        if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
            return (T)Integer.valueOf(jsonArray.getInt(index));
        }
        if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
            return (T)Float.valueOf(jsonArray.getFloat(index));
        }
        if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
            return (T)Double.valueOf(jsonArray.getDouble(index));
        }
        if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
            return (T)Long.valueOf(jsonArray.getLong(index));
        }
        if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
            return (T)Boolean.valueOf(jsonArray.getBoolean(index));
        }
        if (targetType.equals(String.class)) {
            return (T)jsonArray.getString(index);
        }
        if (targetType.equals(List.class)) {
            Type typeOfList = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments()[0];
            return (T)this.castJSONList(jsonArray.getJSONArray(index), (Class)typeOfList);
        }
        if (targetType.equals(Map.class)) {
            Type[] types = ((ParameterizedType)targetType.getGenericSuperclass()).getActualTypeArguments();
            return (T)this.castJSONMap(jsonArray.getJSONObject(index), (Class)types[0], (Class)types[1]);
        }
        if (this.converters.containsKey(targetType)) {
            JSONCustomTypeConverter<?> converter = this.converters.get(targetType);
            return (T)converter.fromJSONArray(jsonArray, index);
        }
        throw new ClassCastException("Unable to cast json value to " + targetType);
    }

    public <T> List<T> castJSONList(JSONArray jsonArray, Class<T> targetType) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(this.castValueFromJSONArray(jsonArray, i, targetType));
        }
        return list;
    }

    public <K, V> Map<K, V> castJSONMap(JSONObject jsonObject, Class<K> keyType, Class<V> valueType) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (String keyName : jsonObject.keySet()) {
            K key = this.castValueFromString(keyName, keyType);
            V value = this.castValueFromJSONObject(jsonObject, keyName, valueType);
            map.put(key, value);
        }
        return map;
    }
}

