/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.snmp.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;
import ru.kirillius.snmp.tools.SNMPConnectionSettings;

public final class SNMPService {
    private static final SNMPService instance = new SNMPService();
    private final PDUFactory pduFactory;
    private final Snmp listener;
    private int retries = 2;
    private long timeout = 5000L;

    public static SNMPService getInstance() {
        return instance;
    }

    private SNMPService() {
        try {
            this.listener = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            this.listener.listen();
            this.pduFactory = new DefaultPDUFactory(-95);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize snmp socket", e);
        }
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        if (retries > 1000 || retries < 0) {
            throw new IllegalArgumentException();
        }
        this.retries = retries;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    private CommunityTarget<Address> configureTarget(SNMPConnectionSettings settings) {
        CommunityTarget<Address> target = settings.toTarget();
        target.setRetries(this.retries);
        target.setTimeout(this.timeout);
        return target;
    }

    public Variable get(String oid, SNMPConnectionSettings settings) throws IOException {
        CommunityTarget<Address> target = this.configureTarget(settings);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(oid)));
        ResponseEvent event = this.listener.get(pdu, target);
        PDU response = event.getResponse();
        if (response == null) {
            return null;
        }
        Iterator iterator = response.getVariableBindings().iterator();
        if (iterator.hasNext()) {
            VariableBinding binding = (VariableBinding)iterator.next();
            return binding.getVariable();
        }
        return null;
    }

    public Variable set(String oid, Variable value, SNMPConnectionSettings settings) throws IOException {
        CommunityTarget<Address> target = this.configureTarget(settings);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(oid), value));
        ResponseEvent event = this.listener.set(pdu, target);
        PDU response = event.getResponse();
        if (response == null) {
            return null;
        }
        Iterator iterator = response.getVariableBindings().iterator();
        if (iterator.hasNext()) {
            VariableBinding binding = (VariableBinding)iterator.next();
            return binding.getVariable();
        }
        return null;
    }

    public VariableBinding getNext(String oid, SNMPConnectionSettings settings) throws IOException {
        CommunityTarget<Address> target = this.configureTarget(settings);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(oid)));
        ResponseEvent event = SNMPService.instance.listener.getNext(pdu, target);
        PDU response = event.getResponse();
        if (response == null) {
            return null;
        }
        Iterator iterator = response.getVariableBindings().iterator();
        if (iterator.hasNext()) {
            VariableBinding binding = (VariableBinding)iterator.next();
            return binding;
        }
        return null;
    }

    public Map<OID, Variable> walk(String oid, SNMPConnectionSettings settings) {
        CommunityTarget<Address> target = this.configureTarget(settings);
        HashMap<OID, Variable> result = new HashMap<OID, Variable>();
        TreeUtils utils = new TreeUtils((Session)this.listener, this.pduFactory);
        for (TreeEvent event : utils.getSubtree(target, new OID(oid))) {
            VariableBinding[] bindings = event.getVariableBindings();
            if (bindings == null) continue;
            for (VariableBinding binding : bindings) {
                result.put(binding.getOid(), binding.getVariable());
            }
        }
        return result;
    }
}

