/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.snmp.tools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.CommunityTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import ru.kirillius.snmp.tools.SNMPVersion;

public class SNMPConnectionSettings {
    private final SNMPVersion version;
    private final InetAddress address;
    private final String community;

    public SNMPConnectionSettings(InetAddress address, String community, SNMPVersion version) {
        this.version = version;
        this.address = address;
        this.community = community;
    }

    public SNMPConnectionSettings(String address, String community, SNMPVersion version) {
        this.version = version;
        try {
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.community = community;
    }

    public CommunityTarget<Address> toTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.community));
        target.setAddress((Address)new UdpAddress(this.address, 161));
        target.setVersion(this.version.getValue());
        target.setTimeout(5000L);
        target.setRetries(2);
        return target;
    }
}

