/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.util.icmp4j;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class ICMPRequest
implements Closeable {
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    private float loss = 100.0f;
    private boolean reachable = false;
    private float latency = 100000.0f;
    private volatile Process process;
    private int received = 0;
    private int latcnt = 0;

    public ICMPRequest(int count, int timeout, InetAddress host) throws IOException {
        String addr = host.getHostAddress();
        this.process = this.createProcess(count, timeout, addr);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            String line;
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                reader.close();
                return;
            }
            while ((line = reader.readLine()) != null) {
                this.parseLine(line, addr);
            }
            if (isWindows) {
                this.reachable = this.received > 0;
                this.loss = 100.0f - 100.0f * (float)this.received / (float)count;
                if (this.received > 0) {
                    this.latency = (float)this.latcnt / (float)this.received;
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public String toString() {
        return "ICMPRequest{loss=" + this.loss + ", reachable=" + this.reachable + ", latency=" + this.latency + "}";
    }

    private Process createProcess(int count, int timeout, String host) throws IOException {
        StringJoiner cmd = new StringJoiner(" ");
        if (isWindows) {
            cmd.add("ping").add("-w").add(String.valueOf(timeout * 1000)).add("-n").add(String.valueOf(count)).add(host);
        } else {
            cmd.add("ping").add("-W").add(String.valueOf(timeout)).add("-c").add(String.valueOf(count)).add(host);
        }
        return Runtime.getRuntime().exec(cmd.toString());
    }

    private void parseLine(String line, String host) {
        if (isWindows) {
            if (line.contains(host + ":") && line.contains("=")) {
                ++this.received;
                String[] split = line.split(Pattern.quote("="));
                this.latcnt = split.length == 4 ? (this.latcnt += Integer.parseInt(split[2].replaceAll("\\D+", "").trim())) : ++this.latcnt;
            }
        } else if (line.contains("transmitted") && line.contains("loss")) {
            for (String part : line.split(Pattern.quote(","))) {
                if (!part.contains("loss")) continue;
                this.loss = Float.parseFloat(part.split(Pattern.quote("%"))[0].trim());
                this.reachable = this.loss < 100.0f;
                return;
            }
        } else if (line.contains("rtt") && line.contains("max")) {
            String[] split = line.split(Pattern.quote("="));
            split = split[1].split(Pattern.quote("/"));
            this.latency = Float.parseFloat(split[1]);
        }
    }

    public float getLoss() {
        return this.loss;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public float getLatency() {
        return this.latency;
    }

    @Override
    public void close() {
        if (this.process != null) {
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
            this.process = null;
        }
    }
}

