/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import ru.kirillius.hibernate.commons.Request;

final class RequestImpl<E>
implements Request<E> {
    private final Query<E> query;
    private final Transaction transaction;
    private final Session session;

    public RequestImpl(Query<E> query, Transaction transaction, Session session) {
        this.query = query;
        this.transaction = transaction;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E getFirst() {
        try {
            Optional<E> first = this.stream().findFirst();
            if (first.isEmpty()) {
                E e = null;
                return e;
            }
            E e = first.get();
            return e;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Stream<E> stream() {
        return this.query.stream();
    }

    @Override
    public Iterator<E> toIterator() {
        return this.stream().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> toList() {
        try {
            List list = this.query.getResultList();
            return list;
        }
        catch (NoResultException nre) {
            List list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> toSet() {
        try {
            Set set = this.query.getResultStream().collect(Collectors.toSet());
            return set;
        }
        catch (NoResultException nre) {
            Set set = Collections.emptySet();
            return set;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void close() throws IOException {
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.commit();
        }
        if (this.session.isOpen()) {
            this.session.close();
        }
    }
}

