/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.hibernate.commons.Request;

public final class DatabaseSession
implements Closeable {
    private final Map<Class<? extends DatabaseEntity>, DatabaseService<?>> registry = new HashMap();
    private final Configuration configuration;
    private SessionFactory sessionFactory;
    private Session session = null;

    @SafeVarargs
    public DatabaseSession(Configuration configuration, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = configuration;
        this.addServicesToConfiguration(configuration, services);
        this.buildSessionFactory();
    }

    @SafeVarargs
    public DatabaseSession(String connectionUrl, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = new Configuration();
        this.configuration.configure();
        this.configuration.getProperties().setProperty("hibernate.connection.url", connectionUrl);
        this.addServicesToConfiguration(this.configuration, services);
        this.buildSessionFactory();
    }

    public Session getSession() {
        return this.sessionFactory.openSession();
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void addServicesToConfiguration(Configuration configuration, Class<? extends DatabaseService<?>>[] services) {
        for (Class<? extends DatabaseService<?>> sc : services) {
            DatabaseService<?> service = this.instantiateService(sc);
            Class<?> ec = service.getEntityClass();
            configuration.addAnnotatedClass(ec);
            this.registry.put(ec, service);
        }
    }

    private DatabaseService<?> instantiateService(Class<? extends DatabaseService<?>> sCls) {
        try {
            Constructor<DatabaseService<?>> constructor = sCls.getDeclaredConstructor(DatabaseSession.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Service", e);
        }
    }

    private void buildSessionFactory() {
        for (Class<? extends DatabaseEntity> mapping : this.registry.keySet()) {
            this.configuration.addAnnotatedClass(mapping);
        }
        this.sessionFactory = this.configuration.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends DatabaseService<?>> S getServiceByClass(Class<S> cls) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            for (DatabaseService<?> service : this.registry.values()) {
                if (!service.getClass().equals(cls)) continue;
                return (S)service;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DatabaseEntity, S extends DatabaseService<E>> S getServiceForEntityType(Class<E> entityClass) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            return (S)this.registry.get(entityClass);
        }
    }

    public void save(DatabaseEntity ... entities) {
        for (DatabaseEntity entity : entities) {
            Object service = this.getServiceForEntityType(entity.getClass());
            if (service == null) {
                throw new IllegalStateException("Service fot entity type " + entity.getClass().getName() + " is not registered");
            }
            service.save((DatabaseEntity)entity);
        }
    }

    public <E extends DatabaseEntity> Request<E> getAllOfType(Class<E> type) {
        Object service = this.getServiceForEntityType(type);
        if (service == null) {
            throw new IllegalStateException("Service fot entity type " + type.getName() + " is not registered");
        }
        return service.getAll();
    }

    public <E extends DatabaseEntity> E getById(long id, Class<E> type) {
        Object service = this.getServiceForEntityType(type);
        if (service == null) {
            throw new IllegalStateException("Service fot entity type " + type.getName() + " is not registered");
        }
        return service.getById(id);
    }

    public void delete(DatabaseEntity ... entities) {
        for (DatabaseEntity entity : entities) {
            Object service = this.getServiceForEntityType(entity.getClass());
            if (service == null) {
                throw new IllegalStateException("Service fot entity type " + entity.getClass().getName() + " is not registered");
            }
            service.delete((DatabaseEntity)entity);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

