/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.StringJoiner;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.hibernate.commons.DatabaseSession;
import ru.kirillius.hibernate.commons.EmptyRequest;
import ru.kirillius.hibernate.commons.Request;
import ru.kirillius.hibernate.commons.RequestImpl;

public abstract class AbstractService<E extends DatabaseEntity>
implements DatabaseService<E> {
    protected DatabaseSession databaseSession;
    protected String tableName;
    protected Class<E> entityClass;
    protected final DatabaseService.Events<E> events = new DatabaseService.Events();

    @Override
    public DatabaseService.Events<E> getEvents() {
        return this.events;
    }

    protected AbstractService(DatabaseSession databaseSession) {
        this.databaseSession = databaseSession;
        this.loadEntityClass();
    }

    private void loadEntityClass() {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            this.tableName = this.entityClass.getSimpleName();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import Entity class for Service<E>: " + this.getClass().getName());
        }
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.entityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getById(long id) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            DatabaseEntity databaseEntity;
            Query q = session.createQuery("from " + this.tableName + " where id = :id", this.entityClass);
            q.setParameter("id", (Object)id);
            try {
                databaseEntity = (DatabaseEntity)q.getSingleResult();
            }
            catch (NoResultException e) {
                E e2 = null;
                transaction.commit();
                session.close();
                return e2;
            }
            return (E)databaseEntity;
        }
        finally {
            transaction.commit();
            session.close();
        }
    }

    @Override
    public final Request<E> getByIds(Collection<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return EmptyRequest.instance;
        }
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        StringJoiner joiner = new StringJoiner(", ");
        for (Long id : ids) {
            joiner.add(id.toString());
        }
        Query q = session.createQuery("from " + this.tableName + " where id IN (" + joiner + ")", this.entityClass);
        return new RequestImpl(q, transaction, session);
    }

    protected final Request<E> searchEntities(String query, Object[] parameters) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        Query q = session.createQuery("from " + this.tableName + " " + query, this.entityClass);
        for (int key = 0; key < parameters.length; ++key) {
            q.setParameter(key + 1, parameters[key]);
        }
        return new RequestImpl(q, transaction, session);
    }

    @Override
    public final Request<E> search(String query, Object ... parameters) {
        return this.searchEntities(query, parameters);
    }

    @Override
    public final Request<E> getAll() {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        return new RequestImpl(session.createQuery("from " + this.tableName, this.entityClass), transaction, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getCount() {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            long l = (Long)session.createQuery("select count(id) as c from " + this.tableName, Long.class).uniqueResult();
            return l;
        }
        finally {
            transaction.commit();
            session.close();
        }
    }

    @Override
    public void save(E entity) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            if (entity.getId() == 0L) {
                session.persist(entity);
            } else {
                session.merge(entity);
            }
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw new RuntimeException(e);
        }
        try {
            this.events.OnSave.invoke(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    @Override
    public final void save(Collection<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.save((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void save(E ... entities) {
        for (E entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public void delete(E entity) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            session.remove(entity);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
        }
        try {
            this.events.OnDelete.invoke(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    @Override
    public final void delete(Collection<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.delete((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void delete(E ... entities) {
        for (E entity : entities) {
            this.delete(entity);
        }
    }
}

