/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.json.convert.JSONCaster;
import ru.kirillius.json.convert.JSONCustomTypeConverter;

public final class DatabaseSession
implements Closeable {
    private final Map<Class<? extends DatabaseEntity>, DatabaseService<?>> registry = new HashMap();
    private final Configuration configuration;
    private final JSONCaster jsonCaster = new JSONCaster();
    private SessionFactory sessionFactory;
    private Session session = null;

    @SafeVarargs
    public DatabaseSession(Configuration configuration, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = configuration;
        this.addServicesToConfiguration(configuration, services);
        this.buildSessionFactory();
        this.initializeJsonCaster();
    }

    @SafeVarargs
    public DatabaseSession(String connectionUrl, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = new Configuration();
        this.configuration.configure();
        this.configuration.getProperties().setProperty("hibernate.connection.url", connectionUrl);
        this.addServicesToConfiguration(this.configuration, services);
        this.buildSessionFactory();
        this.initializeJsonCaster();
    }

    public Session getSession() {
        return this.sessionFactory.openSession();
    }

    public JSONCaster getJsonCaster() {
        return this.jsonCaster;
    }

    private void initializeJsonCaster() {
        this.jsonCaster.addConverter(DatabaseEntity.class, (JSONCustomTypeConverter)new JSONCustomTypeConverter<DatabaseEntity>(){

            private <E> E instantiateEntity(Class<E> ec) {
                try {
                    Constructor<E> constructor = ec.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate Entity class " + ec, e);
                }
            }

            public JSONObject toJSON(DatabaseEntity value, Class<?> targetType) {
                JSONObject json = new JSONObject();
                for (Field field : value.getDatabaseMappedFields()) {
                    field.setAccessible(true);
                    try {
                        if (field.getType().isAssignableFrom(List.class)) {
                            JSONArray list = new JSONArray();
                            for (Object obj : (List)field.get(value)) {
                                if (obj instanceof DatabaseEntity) {
                                    list.put(((DatabaseEntity)obj).getId());
                                    continue;
                                }
                                if (obj == null) continue;
                                DatabaseSession.this.jsonCaster.putToJSONArray(list, list.length(), obj.getClass());
                            }
                            json.put(field.getName(), (Object)list);
                            continue;
                        }
                        Object obj = field.get(value);
                        if (this.isEntityType(field.getType())) {
                            json.put(field.getName(), obj != null ? ((DatabaseEntity)obj).getId() : 0L);
                            continue;
                        }
                        DatabaseSession.this.jsonCaster.putToJSONObject(json, field.getName(), obj);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to read field " + field.getName());
                    }
                }
                return json;
            }

            public DatabaseEntity fromJSONMap(JSONObject map, String key, Class<?> targetClass) {
                return this.fromJSONObject(map.getJSONObject(key), (Class)targetClass);
            }

            public DatabaseEntity fromJSONArray(JSONArray jsonArray, int index, Class<?> targetType) {
                return this.fromJSONObject(jsonArray.getJSONObject(index), (Class)targetType);
            }

            private boolean isEntityType(Class<?> cls) {
                return DatabaseEntity.class.isAssignableFrom(cls);
            }

            public DatabaseEntity fromJSONObject(JSONObject json, Class<?> entityClass) {
                DatabaseEntity entity = (DatabaseEntity)this.instantiateEntity(entityClass);
                List<Field> fields = entity.getDatabaseMappedFields();
                for (String key : json.keySet()) {
                    try {
                        Field field = entityClass.getDeclaredField(key);
                        Class<?> type = field.getType();
                        if (!fields.contains(field)) {
                            throw new RuntimeException("Key " + key + " is not a column!");
                        }
                        field.setAccessible(true);
                        String value = json.get(key).toString();
                        if (this.isEntityType(type)) {
                            Object other;
                            Object service = DatabaseSession.this.getServiceForEntityType(type);
                            long id = Long.parseLong(value);
                            Object v0 = other = id > 0L ? service.getById(id) : null;
                            if (other == null && id > 0L) {
                                throw new RuntimeException("Entity was not found " + type.getName() + "[id=" + id + "]");
                            }
                            field.set(entity, other);
                            continue;
                        }
                        Object fv = DatabaseSession.this.jsonCaster.castValueFromJSONMap(json, key, field.getType());
                        if (fv == null) continue;
                        field.setAccessible(true);
                        field.set(entity, fv);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
                return entity;
            }

            public DatabaseEntity fromString(String string, Class<?> targetType) {
                throw new ClassCastException("Cannot cast from String to " + DatabaseEntity.class);
            }
        });
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void addServicesToConfiguration(Configuration configuration, Class<? extends DatabaseService<?>>[] services) {
        for (Class<? extends DatabaseService<?>> sc : services) {
            DatabaseService<?> service = this.instantiateService(sc);
            Class<?> ec = service.getEntityClass();
            configuration.addAnnotatedClass(ec);
            this.registry.put(ec, service);
        }
    }

    private DatabaseService<?> instantiateService(Class<? extends DatabaseService<?>> sCls) {
        try {
            Constructor<DatabaseService<?>> constructor = sCls.getDeclaredConstructor(DatabaseSession.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Service", e);
        }
    }

    private void buildSessionFactory() {
        for (Class<? extends DatabaseEntity> mapping : this.registry.keySet()) {
            this.configuration.addAnnotatedClass(mapping);
        }
        this.sessionFactory = this.configuration.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends DatabaseService<?>> S getServiceByClass(Class<S> cls) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            for (DatabaseService<?> service : this.registry.values()) {
                if (!service.getClass().equals(cls)) continue;
                return (S)service;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DatabaseEntity, S extends DatabaseService<E>> S getServiceForEntityType(Class<E> entityClass) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            return (S)this.registry.get(entityClass);
        }
    }

    public void save(DatabaseEntity ... entities) {
        for (DatabaseEntity entity : entities) {
            Object service = this.getServiceForEntityType(entity.getClass());
            if (service == null) {
                throw new IllegalStateException("Service fot entity type " + entity.getClass().getName() + " is not registered");
            }
            service.save((DatabaseEntity)entity);
        }
    }

    public void delete(DatabaseEntity ... entities) {
        for (DatabaseEntity entity : entities) {
            Object service = this.getServiceForEntityType(entity.getClass());
            if (service == null) {
                throw new IllegalStateException("Service fot entity type " + entity.getClass().getName() + " is not registered");
            }
            service.delete((DatabaseEntity)entity);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public JSONObject toJSON(DatabaseEntity entity) {
        return this.jsonCaster.castObjectToJSON((Object)entity, entity.getClass());
    }

    public <E extends DatabaseEntity> E fromJSON(JSONObject json, Class<E> targetType) {
        return (E)((DatabaseEntity)this.jsonCaster.castJSONToObject(json, targetType));
    }
}

