/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.kirillius.hibernate.commons.DatabaseEntity;

public abstract class AbstractEntity
implements DatabaseEntity {
    @Override
    public final List<Field> getDatabaseMappedFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(JoinColumn.class)) continue;
            fields.add(field);
        }
        return fields;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.getId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DatabaseEntity)) {
            return false;
        }
        String thisClassname = this.getClass().getName();
        String thatClassname = obj.getClass().getName();
        if (thatClassname.equals(thisClassname)) {
            DatabaseEntity entity = (DatabaseEntity)obj;
            return entity.getId() == this.getId();
        }
        return false;
    }
}

