/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public final class Request<E>
implements Closeable {
    private Query<E> query;
    private final Transaction transaction;

    public Request(Query<E> query, Transaction transaction) {
        this.query = query;
        this.transaction = transaction;
    }

    public E getFirst() {
        Optional<E> first = this.stream().findFirst();
        if (first.isEmpty()) {
            return null;
        }
        return first.get();
    }

    public Stream<E> stream() {
        return this.query.stream();
    }

    public Iterator<E> toIterator() {
        return this.stream().iterator();
    }

    public List<E> toList() {
        try {
            return this.query.getResultList();
        }
        catch (NoResultException nre) {
            return Collections.emptyList();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.commit();
        }
    }
}

