/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.hibernate.commons.DatabaseSession;
import ru.kirillius.hibernate.commons.Request;
import ru.kirillius.java.utils.events.ConcurrentEventHandler;
import ru.kirillius.java.utils.events.EventHandler;

public abstract class AbstractService<E extends DatabaseEntity>
implements DatabaseService<E> {
    protected DatabaseSession databaseSession;
    protected String tableName;
    protected Class<E> entityClass;
    public final EventHandler<E> OnSave = new ConcurrentEventHandler();
    public final EventHandler<E> OnDelete = new ConcurrentEventHandler();

    protected AbstractService(DatabaseSession databaseSession) {
        this.databaseSession = databaseSession;
        this.loadEntityClass();
    }

    private void loadEntityClass() {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            this.tableName = this.entityClass.getSimpleName();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import Entity class for Service<E>: " + this.getClass().getName());
        }
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.entityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getById(long id) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            DatabaseEntity databaseEntity;
            Query q = session.createQuery("from " + this.tableName + " where id = :id", this.entityClass);
            q.setParameter("id", (Object)id);
            try {
                databaseEntity = (DatabaseEntity)q.getSingleResult();
            }
            catch (NoResultException e) {
                E e2 = null;
                transaction.commit();
                return e2;
            }
            return (E)databaseEntity;
        }
        finally {
            transaction.commit();
        }
    }

    protected final Request<E> searchEntities(String query, Object[] parameters) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        Query q = session.createQuery("from " + this.tableName + " " + query, this.entityClass);
        for (int key = 0; key < parameters.length; ++key) {
            q.setParameter(key + 1, parameters[key]);
        }
        return new Request(q, transaction);
    }

    @Override
    public final Request<E> search(String query, Object ... parameters) {
        return this.searchEntities(query, parameters);
    }

    @Override
    public final Request<E> getAll() {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        return new Request(session.createQuery("from " + this.tableName, this.entityClass), transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getCount() {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        try {
            long l = (Long)session.createQuery("select count(id) as c from " + this.tableName, Long.class).uniqueResult();
            return l;
        }
        finally {
            transaction.commit();
        }
    }

    @Override
    public void save(E entity) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        if (entity.getId() == 0L) {
            session.persist(entity);
        } else {
            session.merge(entity);
        }
        transaction.commit();
        try {
            this.OnSave.invoke(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void save(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.save((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void save(E ... entities) {
        for (E entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public void delete(E entity) {
        Session session = this.databaseSession.getSession();
        Transaction transaction = session.beginTransaction();
        session.remove(entity);
        transaction.commit();
        try {
            this.OnDelete.invoke(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void delete(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.delete((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void delete(E ... entities) {
        for (E entity : entities) {
            this.delete(entity);
        }
    }
}

