/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONObject;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.hibernate.commons.DatabaseSession;
import ru.kirillius.hibernate.commons.Request;
import ru.kirillius.util.DynamicTypesUtils;

public abstract class AbstractService<E extends DatabaseEntity>
implements DatabaseService<E> {
    protected DatabaseSession registry;
    protected String tableName;
    protected Class<E> entityClass;

    protected AbstractService(DatabaseSession registry) {
        this.registry = registry;
        this.loadEntityClass();
    }

    private void loadEntityClass() {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            this.tableName = this.entityClass.getSimpleName();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import Entity class for Service<E>: " + this.getClass().getName());
        }
    }

    protected Session openSession() {
        return this.registry.getSessionFactory().openSession();
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public final E getById(long id) {
        try (Session session = this.openSession();){
            DatabaseEntity databaseEntity;
            Query q = session.createQuery("from " + this.tableName + " where id = :id", this.entityClass);
            q.setParameter("id", (Object)id);
            try {
                databaseEntity = (DatabaseEntity)q.getSingleResult();
            }
            catch (NoResultException e) {
                E e2;
                block9: {
                    e2 = null;
                    if (session == null) break block9;
                    session.close();
                }
                return e2;
            }
            return (E)databaseEntity;
        }
    }

    protected final Request<E> searchEntities(String query, Object[] parameters) {
        Session session = this.openSession();
        Query q = session.createQuery("from " + this.tableName + " " + query, this.entityClass);
        for (int key = 0; key < parameters.length; ++key) {
            q.setParameter(key + 1, parameters[key]);
        }
        return new Request(session, q);
    }

    @Override
    public final List<E> search(String query, Object ... parameters) {
        try (Request<E> request = this.searchEntities(query, parameters);){
            List<E> list = request.toList();
            return list;
        }
    }

    @Override
    public final Request<E> searchRequest(String query, Object ... parameters) {
        return this.searchEntities(query, parameters);
    }

    @Override
    public final List<E> getAll() {
        try (Session session = this.openSession();){
            List list = session.createQuery("from " + this.tableName, this.entityClass).list();
            return list;
        }
    }

    @Override
    public final Request<E> getAllRequest() {
        Session session = this.openSession();
        return new Request(session, session.createQuery("from " + this.tableName, this.entityClass));
    }

    @Override
    public final long getCount() {
        try (Session session = this.openSession();){
            long l = (Long)session.createQuery("select count(id) as c from " + this.tableName, Long.class).uniqueResult();
            return l;
        }
    }

    @Override
    public void save(E entity) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            if (entity.getId() == 0L) {
                session.persist(entity);
            } else {
                session.merge(entity);
            }
            transaction.commit();
        }
    }

    @Override
    public final void save(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.save((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void save(E ... entities) {
        for (E entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public void delete(E entity) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            session.remove(entity);
            transaction.commit();
        }
    }

    @Override
    public final void delete(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.delete((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void delete(E ... entities) {
        for (E entity : entities) {
            this.delete(entity);
        }
    }

    protected E instantiateEntity() {
        Class<E> ec = this.getEntityClass();
        try {
            Constructor<E> constructor = ec.getConstructor(new Class[0]);
            return (E)((DatabaseEntity)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Entity class " + ec, e);
        }
    }

    @Override
    public E generateFromJSON(JSONObject json) {
        E entity = this.instantiateEntity();
        List<Field> fields = entity.getDatabaseMappedFields();
        for (String key : json.keySet()) {
            try {
                Field field = this.entityClass.getDeclaredField(key);
                Class<?> type = field.getType();
                if (!fields.contains(field)) {
                    throw new RuntimeException("Key " + key + " is not a column!");
                }
                field.setAccessible(true);
                String value = json.get(key).toString();
                if (DatabaseEntity.class.isAssignableFrom(type)) {
                    long id;
                    Object service = this.registry.getServiceForEntityType(type);
                    Object other = service.getById(id = Long.parseLong(value));
                    if (other == null) {
                        throw new RuntimeException("Entity was not found " + type.getName() + "[id=" + id + "]");
                    }
                    field.set(entity, other);
                    continue;
                }
                Object fv = DynamicTypesUtils.castTo((Object)value, field.getType());
                if (fv == null) continue;
                field.setAccessible(true);
                field.set(entity, fv);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return entity;
    }
}

