/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;

public final class Request<E>
implements Closeable {
    private Session session;
    private Query<E> query;

    protected Request(Session session, Query<E> query) {
        this.session = session;
        this.query = query;
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.query = null;
        }
    }

    public Iterator<E> toIterator() {
        return this.query.stream().iterator();
    }

    public List<E> toList() {
        try {
            return this.query.getResultList();
        }
        catch (NoResultException nre) {
            return Collections.emptyList();
        }
    }
}

