/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.kirillius.hibernate.commons.DatabaseEntity;

public abstract class AbstractEntity
implements DatabaseEntity {
    @Override
    public final List<Field> getDatabaseMappedFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(JoinColumn.class)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (Field field : this.getDatabaseMappedFields()) {
            field.setAccessible(true);
            try {
                if (field.getType().isAssignableFrom(List.class)) {
                    JSONArray list = new JSONArray();
                    for (Object obj : (List)field.get(this)) {
                        if (obj instanceof AbstractEntity) {
                            list.put((Object)((AbstractEntity)obj).toJSON());
                            continue;
                        }
                        list.put((Object)obj.toString());
                    }
                    json.put(field.getName(), (Object)list);
                    continue;
                }
                json.put(field.getName(), (Object)field.get(this).toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to read field " + field.getName());
            }
        }
        return json;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.toJSON().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.getId());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().getName().equals(this.getClass().getName())) {
            return ((AbstractEntity)obj).getId() == this.getId();
        }
        return false;
    }
}

