/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;

public final class DatabaseSession {
    private final Map<Class<? extends DatabaseEntity>, DatabaseService<?>> registry = new HashMap();
    private final Configuration configuration;
    private SessionFactory sessionFactory;

    @SafeVarargs
    public DatabaseSession(Configuration configuration, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = configuration;
        this.addServicesToConfiguration(configuration, services);
        this.buildSessionFactory();
    }

    @SafeVarargs
    public DatabaseSession(String connectionUrl, Class<? extends DatabaseService<?>> ... services) {
        this.configuration = new Configuration();
        this.configuration.configure();
        this.configuration.getProperties().setProperty("hibernate.connection.url", connectionUrl);
        this.addServicesToConfiguration(this.configuration, services);
        this.buildSessionFactory();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void addServicesToConfiguration(Configuration configuration, Class<? extends DatabaseService<?>>[] services) {
        for (Class<? extends DatabaseService<?>> sc : services) {
            DatabaseService<?> service = this.instantiateService(sc);
            Class<?> ec = service.getEntityClass();
            configuration.addAnnotatedClass(ec);
            this.registry.put(ec, service);
        }
    }

    private DatabaseService<?> instantiateService(Class<? extends DatabaseService<?>> sCls) {
        try {
            Constructor<DatabaseService<?>> constructor = sCls.getDeclaredConstructor(DatabaseSession.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Service", e);
        }
    }

    private void buildSessionFactory() {
        for (Class<? extends DatabaseEntity> mapping : this.registry.keySet()) {
            this.configuration.addAnnotatedClass(mapping);
        }
        this.sessionFactory = this.configuration.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends DatabaseService<?>> S getServiceByClass(Class<S> cls) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            for (DatabaseService<?> service : this.registry.values()) {
                if (!service.getClass().equals(cls)) continue;
                return (S)service;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DatabaseEntity, S extends DatabaseService<E>> S getServiceForEntityType(Class<E> entityClass) {
        Map<Class<? extends DatabaseEntity>, DatabaseService<?>> map = this.registry;
        synchronized (map) {
            return (S)this.registry.get(entityClass);
        }
    }
}

