/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.hibernate.commons;

import jakarta.persistence.NoResultException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONObject;
import ru.kirillius.hibernate.commons.DatabaseEntity;
import ru.kirillius.hibernate.commons.DatabaseService;
import ru.kirillius.hibernate.commons.DatabaseSession;
import ru.kirillius.util.DynamicTypesUtils;

public abstract class AbstractService<E extends DatabaseEntity>
implements DatabaseService<E> {
    protected DatabaseSession registry;
    protected String tableName;
    protected Class<E> entityClass;

    protected AbstractService(DatabaseSession registry) {
        this.registry = registry;
        this.loadEntityClass();
    }

    private void loadEntityClass() {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            this.tableName = this.entityClass.getSimpleName();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import Entity class for Service<E>: " + this.getClass().getName());
        }
    }

    protected Session openSession() {
        return this.registry.getSessionFactory().openSession();
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public final E getById(long id) {
        try (Session session = this.openSession();){
            DatabaseEntity databaseEntity;
            Query q = session.createQuery("from " + this.tableName + " where id = :id", this.entityClass);
            q.setParameter("id", (Object)id);
            try {
                databaseEntity = (DatabaseEntity)q.getSingleResult();
            }
            catch (NoResultException e) {
                E e2;
                block9: {
                    e2 = null;
                    if (session == null) break block9;
                    session.close();
                }
                return e2;
            }
            return (E)databaseEntity;
        }
    }

    @Override
    @SafeVarargs
    public final List<E> search(E ... objects) {
        ArrayList<E> entities = new ArrayList<E>();
        for (E entity : objects) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringJoiner joiner = new StringJoiner(" and ");
            int i = 1;
            for (Field field : entity.getDatabaseMappedFields()) {
                if (field.getName().equals("id")) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(entity);
                    if (value == null) continue;
                    joiner.add(field.getName() + " = ?" + i++);
                    parameters.add(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            entities.addAll(this.searchEntities(" where " + joiner, parameters.toArray()));
        }
        return entities;
    }

    protected final List<E> searchEntities(String query, Object[] parameters) {
        try (Session session = this.openSession();){
            Query q = session.createQuery("from " + this.tableName + " " + query, this.entityClass);
            for (int key = 0; key < parameters.length; ++key) {
                q.setParameter(key + 1, parameters[key]);
            }
            try {
                List key = q.getResultList();
                return key;
            }
            catch (NoResultException e) {
                List<E> list;
                block10: {
                    list = null;
                    if (session == null) break block10;
                    session.close();
                }
                return list;
            }
        }
    }

    @Override
    public final List<E> search(String query, Object ... parameters) {
        return this.searchEntities(query, parameters);
    }

    @Override
    public final List<E> getAll() {
        try (Session session = this.openSession();){
            List list = session.createQuery("from " + this.tableName, this.entityClass).list();
            return list;
        }
    }

    public final Iterator<E> getAllAsIterable() {
        return new QueryIterator("from " + this.tableName);
    }

    @Override
    public final long getCount() {
        try (Session session = this.openSession();){
            long l = (Long)session.createQuery("select count(id) as c from " + this.tableName, Long.class).uniqueResult();
            return l;
        }
    }

    @Override
    public final void save(E entity) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            if (entity.getId() == 0L) {
                session.persist(entity);
            } else {
                session.merge(entity);
            }
            transaction.commit();
        }
    }

    @Override
    public final void save(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.save((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void save(E ... entities) {
        for (E entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public void delete(E entity) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            session.remove(entity);
            transaction.commit();
        }
    }

    @Override
    public final void delete(List<E> entities) {
        for (DatabaseEntity entity : entities) {
            this.delete((E)entity);
        }
    }

    @Override
    @SafeVarargs
    public final void delete(E ... entities) {
        for (E entity : entities) {
            this.delete(entity);
        }
    }

    protected E instantiateEntity() {
        Class<E> ec = this.getEntityClass();
        try {
            Constructor<E> constructor = ec.getConstructor(new Class[0]);
            return (E)((DatabaseEntity)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Entity class " + ec, e);
        }
    }

    @Override
    public E generateFromJSON(JSONObject json) {
        E entity = this.instantiateEntity();
        List<Field> fields = entity.getDatabaseMappedFields();
        for (String key : json.keySet()) {
            try {
                Field field = this.getClass().getDeclaredField(key);
                Class<?> type = field.getType();
                if (!fields.contains(field)) {
                    throw new RuntimeException("Key " + key + " is not a column!");
                }
                field.setAccessible(true);
                String value = json.get(key).toString();
                if (DatabaseEntity.class.isAssignableFrom(type)) {
                    long id;
                    Object service = this.registry.getServiceForEntityType(type);
                    Object other = service.getById(id = Long.parseLong(value));
                    if (other == null) {
                        throw new RuntimeException("Entity was not found " + type.getName() + "[id=" + id + "]");
                    }
                    field.set(this, other);
                    continue;
                }
                Object fv = DynamicTypesUtils.castTo((Object)value, field.getType());
                if (fv == null) continue;
                field.setAccessible(true);
                field.set(this, fv);
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return entity;
    }

    private final class QueryIterator<E>
    implements Iterator<E> {
        private Session session = null;
        private Iterator<E> iterator = null;

        public QueryIterator(String query) {
            this.session = AbstractService.this.openSession();
            this.iterator = this.session.createQuery(query, AbstractService.this.entityClass).stream().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.session == null || this.iterator == null) {
                return false;
            }
            boolean next = this.iterator.hasNext();
            if (!next) {
                this.session.close();
                this.iterator = null;
                this.session = null;
            }
            return next;
        }

        @Override
        public E next() {
            if (this.session == null || this.iterator == null) {
                return null;
            }
            return this.iterator.next();
        }
    }
}

