/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.fiction.book.parser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.kirillius.fiction.book.parser.Entities.FictionBook;
import ru.kirillius.fiction.book.parser.FBParseException;
import ru.kirillius.fiction.book.parser.XMLDocumentEntityResolver;

public class FBParser {
    private static final DocumentBuilder parser;

    public FictionBook parse(InputStream is) throws FBParseException {
        XMLDocumentEntityResolver resolver = new XMLDocumentEntityResolver(is);
        try {
            Document document = parser.parse(resolver);
            document.normalize();
            NodeList list = document.getElementsByTagName("FictionBook");
            if (list.getLength() == 0) {
                throw new FBParseException("Failed to find any FictionBook tag");
            }
            FictionBook fictionBook = new FictionBook();
            fictionBook.loadFromXMLNode(list.item(0));
            return fictionBook;
        }
        catch (IOException | SAXException e) {
            throw new FBParseException("Failed to parse XML document", e);
        }
    }

    static {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            parser = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to initialize XML parser", e);
        }
    }
}

