/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.fiction.book.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.kirillius.fiction.book.parser.FBParseException;
import ru.kirillius.fiction.book.parser.XMLAttribute;
import ru.kirillius.fiction.book.parser.XMLContent;
import ru.kirillius.fiction.book.parser.XMLEntity;
import ru.kirillius.fiction.book.parser.XMLEntityList;
import ru.kirillius.fiction.book.parser.XMLStructure;

public class AbstractXMLBindingStructure
implements XMLStructure {
    @Override
    public void loadFromXMLNode(Node elementNode) throws FBParseException {
        Element element = this.getElement(elementNode);
        block6: for (Field field : this.getClass().getDeclaredFields()) {
            int i;
            NodeList childNodes;
            if (field.isAnnotationPresent(XMLEntity.class)) {
                XMLEntity entity = field.getAnnotation(XMLEntity.class);
                childNodes = element.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (!node.getNodeName().equals(entity.value()) || node.getNodeType() != 1) continue;
                    try {
                        Object data = this.ProcessStructure(field.getType(), node);
                        field.setAccessible(true);
                        try {
                            field.set(this, data);
                        }
                        catch (IllegalAccessException e) {
                            throw new FBParseException("Failed to set value " + data + " to structure " + this.getClass().getSimpleName() + "::" + field, e);
                        }
                    }
                    catch (NumberFormatException data) {}
                    continue block6;
                }
                continue;
            }
            if (field.isAnnotationPresent(XMLEntityList.class)) {
                XMLEntityList entityList = field.getAnnotation(XMLEntityList.class);
                childNodes = element.getChildNodes();
                field.setAccessible(true);
                try {
                    List list = (List)field.get(this);
                    for (int i2 = 0; i2 < childNodes.getLength(); ++i2) {
                        Node node = childNodes.item(i2);
                        if (!node.getNodeName().equals(entityList.tag()) || node.getNodeType() != 1) continue;
                        Object data = this.ProcessStructure(entityList.targetType(), node);
                        list.add(data);
                    }
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new FBParseException("Failed to get List of " + this.getClass().getSimpleName() + "::" + field.getName(), e);
                }
            }
            if (field.isAnnotationPresent(XMLContent.class)) {
                this.setFieldValue(field, elementNode.getTextContent());
                continue;
            }
            if (!field.isAnnotationPresent(XMLAttribute.class)) continue;
            XMLAttribute annotation = field.getAnnotation(XMLAttribute.class);
            NamedNodeMap attributes = elementNode.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                Node attrNode = attributes.item(i);
                if (!attrNode.getNodeName().equals(annotation.value())) continue;
                this.setFieldValue(field, attrNode.getTextContent());
            }
        }
    }

    protected Element getElement(Node node) throws FBParseException {
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new FBParseException("NODE is not an ELEMENT " + node);
    }

    protected void setFieldValue(Field field, String value) {
        Class<?> type = field.getType();
        field.setAccessible(true);
        try {
            field.set(this, this.cast(field.getType(), value));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private <T> T cast(Class<T> type, String value) {
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(Long.parseLong(value));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.valueOf(Short.parseShort(value));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(Double.parseDouble(value));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (type.equals(String.class)) {
            return (T)value;
        }
        throw new RuntimeException("Failed to cast type string to " + type.getSimpleName());
    }

    protected <T> T ProcessStructure(Class<T> structureClass, Node node) throws FBParseException {
        if (XMLStructure.class.isAssignableFrom(structureClass)) {
            try {
                Constructor<T> constructor = structureClass.getConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                ((XMLStructure)instance).loadFromXMLNode(node);
                return instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cast(structureClass, node.getTextContent());
    }
}

