/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.fiction.book.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.StringJoiner;
import org.json.JSONObject;
import org.json.JSONTokener;

public class XMLDocumentEntityResolver
extends InputStream {
    private static final Map<String, String> xmlentities = new HashMap<String, String>();
    private final InputStream source;
    private final char[] readBuffer = new char[1024];
    private final Queue<Character> outputBuffer = new ArrayDeque<Character>();

    public XMLDocumentEntityResolver(InputStream source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        if (!this.outputBuffer.isEmpty()) {
            return this.outputBuffer.poll().charValue();
        }
        int character = this.source.read();
        if (character == -1) {
            return -1;
        }
        if (character == 38) {
            int offset = 0;
            this.readBuffer[offset++] = (char)character;
            while ((character = this.source.read()) != -1) {
                this.readBuffer[offset++] = (char)character;
                if (character == 59) {
                    String key = new String(this.readBuffer, 0, offset);
                    if (xmlentities.containsKey(key)) {
                        for (char c : xmlentities.get(key).toCharArray()) {
                            this.outputBuffer.add(Character.valueOf(c));
                        }
                    } else {
                        for (int i = 0; i < offset; ++i) {
                            this.outputBuffer.add(Character.valueOf(this.readBuffer[i]));
                        }
                    }
                } else {
                    if (offset != this.readBuffer.length) continue;
                    for (int i = 0; i < offset; ++i) {
                        this.outputBuffer.add(Character.valueOf(this.readBuffer[i]));
                    }
                }
                break;
            }
        } else {
            return character;
        }
        return this.outputBuffer.isEmpty() ? -1 : (int)this.outputBuffer.poll().charValue();
    }

    static {
        try (InputStream entitiesStream = XMLDocumentEntityResolver.class.getClassLoader().getResourceAsStream("xmlentities.json");){
            JSONTokener tokener = new JSONTokener(Objects.requireNonNull(entitiesStream));
            JSONObject entities = new JSONObject(tokener);
            for (String key : entities.keySet()) {
                if (!key.endsWith(";") || !key.startsWith("&")) continue;
                JSONObject item = (JSONObject)entities.get(key);
                StringJoiner joiner = new StringJoiner("");
                for (Object cp : item.getJSONArray("codepoints")) {
                    joiner.add("&#" + cp.toString() + ";");
                }
                xmlentities.put(key, joiner.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load xml entities list", e);
        }
    }
}

