/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.compiler;

import java.util.Collections;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import ru.kirillius.compiler.CompilationException;
import ru.kirillius.compiler.RuntimeFileManager;
import ru.kirillius.compiler.SourceCode;

public class RuntimeCompiler {
    private final RuntimeFileManager fileManager;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public RuntimeCompiler() {
        if (this.compiler == null) {
            throw new RuntimeException("System Java compiler is not available");
        }
        this.fileManager = new RuntimeFileManager(this.compiler.getStandardFileManager(null, null, null));
    }

    public Class<?> compile(SourceCode sourceCode) throws CompilationException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, diagnostics, null, null, Collections.singletonList(sourceCode));
        if (!task.call().booleanValue()) {
            throw CompilationException.build(diagnostics);
        }
        try {
            return this.fileManager.getClassLoader(null).loadClass(sourceCode.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Unable to load compiled class", e);
        }
    }
}

