/*
 * Decompiled with CFR 0.152.
 */
package ru.kirillius.FFMPEG4J;

import java.io.BufferedReader;
import java.io.IOException;
import ru.kirillius.FFMPEG4J.LoggerAdapterInterface;

public class ProcessInfoParser {
    public static final int defaultWarmUpDeadTimer = 30;
    public static final int defaultRunningDeadTimer = 10;
    private BufferedReader stream;
    private LoggerAdapterInterface loggerAdapter;
    private boolean sourceLocked = false;
    private long lastUpdate = 0L;
    private volatile int fps = 0;
    private volatile String bitrate = "0";
    private volatile int warmUpTimer = 30;
    private volatile int deadTimer = 10;
    private volatile int currentTimer;

    public ProcessInfoParser(BufferedReader stream, LoggerAdapterInterface loggerAdapterInterface) {
        this.loggerAdapter = loggerAdapterInterface;
        this.stream = stream;
        this.lastUpdate = System.currentTimeMillis();
        this.currentTimer = this.warmUpTimer;
    }

    public boolean isSourceLocked() {
        return this.sourceLocked;
    }

    public int getWarmUpTimer() {
        return this.warmUpTimer;
    }

    public void setWarmUpTimer(int warmUpTimer) {
        this.warmUpTimer = warmUpTimer;
    }

    public int getDeadTimer() {
        return this.deadTimer;
    }

    public void setDeadTimer(int deadTimer) {
        this.deadTimer = deadTimer;
    }

    public boolean isStreamAlive() {
        return System.currentTimeMillis() - this.lastUpdate <= (long)(this.currentTimer * 1000);
    }

    public int getFps() {
        return this.fps;
    }

    public String getBitrate() {
        return this.bitrate;
    }

    private String getLineParam(String line, String param) {
        int begin = line.indexOf(param);
        if (begin >= 0) {
            line = line.substring(begin + param.length()).trim();
            String[] split = line.split(" ");
            return split[0];
        }
        return "";
    }

    private void updateInfo(String line) {
        this.fps = (int)Double.parseDouble(this.getLineParam(line, "fps="));
        this.bitrate = this.getLineParam(line, "bitrate=");
        this.sourceLocked = true;
        this.lastUpdate = System.currentTimeMillis();
        this.currentTimer = this.deadTimer;
    }

    public void read() throws IOException {
        int chr;
        StringBuilder buffer = new StringBuilder();
        while (this.stream.ready() && (chr = this.stream.read()) != -1) {
            String message;
            buffer.append((char)chr);
            if (chr != 13 && chr != 10) continue;
            if (buffer.indexOf("frame=") >= 0) {
                this.updateInfo(buffer.toString());
            } else if (this.loggerAdapter != null && (message = buffer.toString().trim()).length() > 0) {
                this.loggerAdapter.printMessage(message);
            }
            buffer.setLength(0);
        }
    }
}

